BEGIN;

INSERT INTO version(id, "release", name, "type", description, "date")
VALUES (01254, '6.5.0', 'add-attachment-table-for-workstream-attachments', 'FEATURE', 'Moving workstream attachments (e.g. documents or videos) from workstream_entry_attributes to a new table for better performance', now());

CREATE TABLE workstream_attachments (
    entry_id BIGINT NOT NULL,
    item_id BIGINT NOT NULL,
    item_type VARCHAR(32) NOT NULL,
    PRIMARY KEY (item_id, item_type),
    FOREIGN KEY ( entry_id ) REFERENCES workstream_entries ( id )  ON DELETE CASCADE
);

INSERT INTO workstream_attachments (entry_id, item_id, item_type)
    SELECT entry_id, split_part(value, ',', 2)::bigint as item_id, split_part(value, ',', 1) as item_type
    FROM workstream_entry_attributes
    WHERE key = 'attachment_id';

DELETE FROM workstream_entry_attributes
    WHERE key = 'attachment_id';

COMMIT;