/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.structure.constraint.impl;

import org.dbmaintain.database.Database;
import org.dbmaintain.database.Databases;
import org.dbmaintain.structure.constraint.ConstraintsDisabler;
import thirdparty.org.apache.commons.logging.Log;
import thirdparty.org.apache.commons.logging.LogFactory;

public class DefaultConstraintsDisabler
implements ConstraintsDisabler {
    private static Log logger = LogFactory.getLog(DefaultConstraintsDisabler.class);
    protected Databases databases;

    public DefaultConstraintsDisabler(Databases databases) {
        this.databases = databases;
    }

    public void disableConstraints() {
        this.disableReferentialConstraints();
        this.disableValueConstraints();
    }

    public void disableReferentialConstraints() {
        for (Database database : this.databases.getDatabases()) {
            for (String schemaName : database.getSchemaNames()) {
                logger.info("Disabling referential constraints in database schema " + schemaName);
                database.disableReferentialConstraints(schemaName);
            }
        }
    }

    public void disableValueConstraints() {
        for (Database database : this.databases.getDatabases()) {
            for (String schemaName : database.getSchemaNames()) {
                logger.info("Disabling value constraints in database schema " + schemaName);
                database.disableValueConstraints(schemaName);
            }
        }
    }
}

