/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.structure.clear;

import java.util.HashSet;
import java.util.Set;
import org.dbmaintain.MainFactory;
import org.dbmaintain.config.FactoryWithDatabase;
import org.dbmaintain.script.executedscriptinfo.ExecutedScriptInfoSource;
import org.dbmaintain.structure.clear.DBClearer;
import org.dbmaintain.structure.clear.impl.DefaultDBClearer;
import org.dbmaintain.structure.constraint.ConstraintsDisabler;
import org.dbmaintain.structure.model.DbItemIdentifier;
import org.dbmaintain.structure.model.DbItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBClearerFactory
extends FactoryWithDatabase<DBClearer> {
    @Override
    public DBClearer createInstance() {
        Set<DbItemIdentifier> itemsToPreserve = this.getItemsToPreserve();
        MainFactory mainFactory = this.factoryWithDatabaseContext.getMainFactory();
        ConstraintsDisabler constraintsDisabler = mainFactory.createConstraintsDisabler();
        ExecutedScriptInfoSource executedScriptInfoSource = mainFactory.createExecutedScriptInfoSource();
        return new DefaultDBClearer(this.getDatabases(), itemsToPreserve, constraintsDisabler, executedScriptInfoSource);
    }

    protected Set<DbItemIdentifier> getItemsToPreserve() {
        DbItemIdentifier executedScriptsTable = this.factoryWithDatabaseContext.getExecutedScriptsTable();
        Set<DbItemIdentifier> schemasToPreserve = this.factoryWithDatabaseContext.getSchemasToPreserve("dbMaintainer.preserve.schemas");
        HashSet<DbItemIdentifier> itemsToPreserve = new HashSet<DbItemIdentifier>();
        itemsToPreserve.add(executedScriptsTable);
        itemsToPreserve.addAll(schemasToPreserve);
        this.factoryWithDatabaseContext.addItemsToPreserve(DbItemType.TABLE, "dbMaintainer.preserve.tables", itemsToPreserve);
        this.factoryWithDatabaseContext.addItemsToPreserve(DbItemType.VIEW, "dbMaintainer.preserve.views", itemsToPreserve);
        this.factoryWithDatabaseContext.addItemsToPreserve(DbItemType.MATERIALIZED_VIEW, "dbMaintainer.preserve.materializedViews", itemsToPreserve);
        this.factoryWithDatabaseContext.addItemsToPreserve(DbItemType.SYNONYM, "dbMaintainer.preserve.synonyms", itemsToPreserve);
        this.factoryWithDatabaseContext.addItemsToPreserve(DbItemType.SEQUENCE, "dbMaintainer.preserve.sequences", itemsToPreserve);
        this.factoryWithDatabaseContext.addItemsToPreserve(DbItemType.TRIGGER, "dbMaintainer.preserve.triggers", itemsToPreserve);
        this.factoryWithDatabaseContext.addItemsToPreserve(DbItemType.TYPE, "dbMaintainer.preserve.types", itemsToPreserve);
        return itemsToPreserve;
    }
}

