/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.runner.impl.db2;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.DatabaseInfo;
import org.dbmaintain.database.Databases;
import org.dbmaintain.script.runner.impl.Application;
import org.dbmaintain.script.runner.impl.BaseNativeScriptRunner;
import org.dbmaintain.script.runner.impl.db2.Db2ConnectionInfo;
import org.dbmaintain.util.DbMaintainException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Db2ScriptRunner
extends BaseNativeScriptRunner {
    protected Application application;
    protected Map<Database, Db2ConnectionInfo> db2ConnectionInfos;

    public Db2ScriptRunner(Databases databases, String db2Command) {
        super(databases);
        this.application = this.createApplication(db2Command);
        this.db2ConnectionInfos = this.getDb2ConnectionInfos(databases);
    }

    @Override
    public void initialize() {
        for (Db2ConnectionInfo db2ConnectionInfo : this.db2ConnectionInfos.values()) {
            this.unregisterDatabaseQuietly(db2ConnectionInfo);
            this.registerDatabase(db2ConnectionInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            for (Db2ConnectionInfo db2ConnectionInfo : this.db2ConnectionInfos.values()) {
                this.unregisterDatabase(db2ConnectionInfo);
            }
        }
        finally {
            this.terminateDb2Connections();
        }
    }

    protected void terminateDb2Connections() {
        try {
            this.executeCommand("terminate");
        }
        catch (Exception e) {
            throw new DbMaintainException("Unable to terminate database connections.", e);
        }
    }

    protected void registerDatabase(Db2ConnectionInfo db2ConnectionInfo) {
        try {
            if (db2ConnectionInfo.isRemote()) {
                this.executeCommand("catalog tcpip node " + db2ConnectionInfo.getDatabaseAlias() + " remote " + db2ConnectionInfo.getHost() + " server " + db2ConnectionInfo.getPort());
                this.executeCommand("catalog database " + db2ConnectionInfo.getDatabaseName() + " as " + db2ConnectionInfo.getDatabaseAlias() + " at node " + db2ConnectionInfo.getDatabaseAlias());
            }
        }
        catch (Exception e) {
            throw new DbMaintainException("Unable to register database alias " + db2ConnectionInfo.getDatabaseAlias(), e);
        }
    }

    protected void unregisterDatabaseQuietly(Db2ConnectionInfo db2ConnectionInfo) {
        try {
            this.unregisterDatabase(db2ConnectionInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void unregisterDatabase(Db2ConnectionInfo db2ConnectionInfo) {
        try {
            if (db2ConnectionInfo.isRemote()) {
                this.executeCommand("uncatalog database " + db2ConnectionInfo.getDatabaseAlias());
                this.executeCommand("uncatalog node " + db2ConnectionInfo.getDatabaseAlias());
            }
        }
        catch (Exception e) {
            throw new DbMaintainException("Unable to unregister database alias " + db2ConnectionInfo.getDatabaseAlias(), e);
        }
    }

    @Override
    protected void executeScript(File scriptFile, Database targetDatabase) throws Exception {
        Db2ConnectionInfo db2ConnectionInfo = this.db2ConnectionInfos.get(targetDatabase);
        this.executeCommand(false, "connect to " + db2ConnectionInfo.getDatabaseAlias() + " user " + db2ConnectionInfo.getUserName() + " using " + db2ConnectionInfo.getPassword());
        this.executeCommand("set SQLCOMPAT PLSQL");
        this.executeCommand("set schema " + targetDatabase.getDefaultSchemaName());
        this.executeCommand("-t", "-s", "-v", "-c-", "-f" + scriptFile.getPath());
        this.executeCommand("commit");
    }

    protected void executeCommand(String ... command) {
        this.executeCommand(true, command);
    }

    protected void executeCommand(boolean logCommand, String ... command) {
        Application.ProcessOutput processOutput = this.application.execute(logCommand, command);
        int exitValue = processOutput.getExitValue();
        if (exitValue == 4 || exitValue == 8) {
            throw new DbMaintainException("Failed to execute command. DB2 CLP returned an error.\n" + processOutput.getOutput());
        }
    }

    protected Application createApplication(String db2Command) {
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        environmentVariables.put("DB2CLP", "**$$**");
        return new Application("DB2 CLP", db2Command, environmentVariables);
    }

    protected Map<Database, Db2ConnectionInfo> getDb2ConnectionInfos(Databases databases) {
        HashMap<Database, Db2ConnectionInfo> result = new HashMap<Database, Db2ConnectionInfo>();
        int aliasCount = 1;
        for (Database database : databases.getDatabases()) {
            String remoteAlias = "dbm" + aliasCount++;
            DatabaseInfo databaseInfo = database.getDatabaseInfo();
            Db2ConnectionInfo db2ConnectionInfo = Db2ConnectionInfo.parseFromJdbcUrl(databaseInfo.getUrl(), remoteAlias, databaseInfo.getUserName(), databaseInfo.getPassword());
            result.put(database, db2ConnectionInfo);
        }
        return result;
    }
}

