/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.runner.impl.db2;

import org.dbmaintain.util.DbMaintainException;
import thirdparty.org.apache.commons.lang.StringUtils;

public class Db2ConnectionInfo {
    protected static String DEFAULT_PORT = "50000";
    protected String host;
    protected String port;
    protected String databaseName;
    protected String remoteAlias;
    protected String userName;
    protected String password;

    public Db2ConnectionInfo(String databaseName, String userName, String password) {
        this(null, null, databaseName, null, userName, password);
    }

    public Db2ConnectionInfo(String host, String port, String databaseName, String remoteAlias, String userName, String password) {
        this.host = host;
        this.port = port;
        this.databaseName = databaseName;
        this.remoteAlias = remoteAlias;
        this.userName = userName;
        this.password = password;
    }

    public boolean isRemote() {
        return this.host != null;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseAlias() {
        if (this.isRemote()) {
            return this.remoteAlias;
        }
        return this.databaseName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public static Db2ConnectionInfo parseFromJdbcUrl(String jdbcUrl, String remoteAlias, String userName, String password) {
        if (jdbcUrl.contains("/")) {
            return Db2ConnectionInfo.parseFromType4JdbcUrl(jdbcUrl, remoteAlias, userName, password);
        }
        return Db2ConnectionInfo.parseFromType2JdbcUrl(jdbcUrl, userName, password);
    }

    protected static Db2ConnectionInfo parseFromType4JdbcUrl(String jdbcUrl, String remoteAlias, String userName, String password) {
        try {
            int beginIndex = jdbcUrl.indexOf("//");
            int endIndex = jdbcUrl.indexOf(47, beginIndex + 2);
            if (beginIndex == -1 || endIndex == -1) {
                throw new DbMaintainException("Invalid url structure.");
            }
            String hostAndPort = jdbcUrl.substring(beginIndex + 2, endIndex);
            if (StringUtils.isBlank(hostAndPort)) {
                throw new DbMaintainException("Host is missing.");
            }
            String database = jdbcUrl.substring(endIndex + 1);
            if (StringUtils.isBlank(database)) {
                throw new DbMaintainException("Database is missing.");
            }
            int portIndex = hostAndPort.indexOf(58);
            if (portIndex == -1) {
                return new Db2ConnectionInfo(hostAndPort, DEFAULT_PORT, database, remoteAlias, userName, password);
            }
            String host = hostAndPort.substring(0, portIndex);
            String port = hostAndPort.substring(portIndex + 1);
            return new Db2ConnectionInfo(host, port, database, remoteAlias, userName, password);
        }
        catch (Throwable t) {
            throw new DbMaintainException("Unable to parse type 4 DB2 jdbc url. Url should have following form: jdbc:(db2)|(db:net)|(ids)://host(:port)/database. Url: " + jdbcUrl, t);
        }
    }

    protected static Db2ConnectionInfo parseFromType2JdbcUrl(String jdbcUrl, String userName, String password) {
        try {
            int firstIndex = jdbcUrl.indexOf(58);
            int secondIndex = jdbcUrl.indexOf(58, firstIndex + 1);
            if (firstIndex == -1 || secondIndex == -1) {
                throw new DbMaintainException("Invalid url structure.");
            }
            String database = jdbcUrl.substring(secondIndex + 1);
            if (StringUtils.isBlank(database)) {
                throw new DbMaintainException("Database is missing.");
            }
            return new Db2ConnectionInfo(database, userName, password);
        }
        catch (Throwable t) {
            throw new DbMaintainException("Unable to parse type 2 DB2 jdbc url. Url should have following form: jdbc:db2:database. Url: " + jdbcUrl, t);
        }
    }
}

