/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.runner.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dbmaintain.util.DbMaintainException;
import thirdparty.org.apache.commons.lang.StringUtils;
import thirdparty.org.apache.commons.logging.Log;
import thirdparty.org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application {
    private static Log logger = LogFactory.getLog(Application.class);
    private String name;
    private String command;
    private Map<String, String> environmentVariables;

    public Application(String name, String command) {
        this(name, command, new HashMap<String, String>());
    }

    public Application(String name, String command, Map<String, String> environmentVariables) {
        this.name = name;
        this.command = command;
        this.environmentVariables = environmentVariables;
    }

    public ProcessOutput execute(String ... arguments) {
        return this.execute(true, arguments);
    }

    public ProcessOutput execute(boolean logCommand, String ... arguments) {
        try {
            List<String> commandWithArguments = this.getProcessArguments(arguments);
            ProcessBuilder processBuilder = this.createProcessBuilder(commandWithArguments);
            Process process = processBuilder.start();
            OutputProcessor outputProcessor = new OutputProcessor(process);
            outputProcessor.start();
            process.waitFor();
            String output = outputProcessor.getOutput();
            int exitValue = process.exitValue();
            this.logOutput(commandWithArguments, output, logCommand);
            return new ProcessOutput(output, exitValue);
        }
        catch (Exception e) {
            throw new DbMaintainException("Failed to execute command.", e);
        }
    }

    protected void logOutput(List<String> commandWithArguments, String output, boolean logCommand) {
        StringBuilder command = new StringBuilder();
        if (logCommand) {
            for (String part : commandWithArguments) {
                command.append(part);
                command.append(" ");
            }
        }
        logger.debug(this.name + ": " + command + "\n" + output);
    }

    protected ProcessBuilder createProcessBuilder(List<String> commandWithArguments) {
        ProcessBuilder processBuilder = new ProcessBuilder(commandWithArguments);
        Map<String, String> processEnvironment = processBuilder.environment();
        processEnvironment.putAll(this.environmentVariables);
        processBuilder.redirectErrorStream(true);
        return processBuilder;
    }

    protected List<String> getProcessArguments(String[] arguments) {
        ArrayList<String> commandWithArguments = new ArrayList<String>();
        commandWithArguments.add(this.command);
        commandWithArguments.addAll(Arrays.asList(arguments));
        return commandWithArguments;
    }

    protected class OutputProcessor
    extends Thread {
        private StringBuilder outputStringBuilder = new StringBuilder();
        private Process process;

        public OutputProcessor(Process process) {
            this.process = process;
        }

        public void run() {
            try {
                this.appendProcessOutput(this.process);
            }
            catch (Throwable t) {
                logger.warn("Unable to handle application output for " + Application.this.command, t);
            }
        }

        public String getOutput() {
            return this.outputStringBuilder.toString();
        }

        protected void appendProcessOutput(Process process) throws IOException {
            String line;
            BufferedReader outReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = outReader.readLine()) != null) {
                if (StringUtils.isBlank(line)) continue;
                this.outputStringBuilder.append(line);
                this.outputStringBuilder.append('\n');
            }
            outReader.close();
        }
    }

    public static class ProcessOutput {
        private String output;
        private int exitValue;

        public ProcessOutput(String output, int exitValue) {
            this.output = output;
            this.exitValue = exitValue;
        }

        public String getOutput() {
            return this.output;
        }

        public int getExitValue() {
            return this.exitValue;
        }
    }
}

