/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.parser.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import org.dbmaintain.script.parser.ScriptParser;
import org.dbmaintain.script.parser.impl.StatementBuilder;
import org.dbmaintain.script.parser.parsingstate.ParsingState;
import org.dbmaintain.util.DbMaintainException;

public class DefaultScriptParser
implements ScriptParser {
    protected Reader scriptReader;
    protected boolean backSlashEscapingEnabled;
    protected Properties scriptParameters;
    protected ParsingState initialParsingState;
    protected boolean endOfScriptReached = false;
    protected Character currentChar;
    protected Character nextChar;

    public DefaultScriptParser(Reader scriptReader, ParsingState initialParsingState, boolean backSlashEscapingEnabled, Properties scriptParameters) {
        this.scriptReader = scriptReader;
        this.backSlashEscapingEnabled = backSlashEscapingEnabled;
        this.initialParsingState = initialParsingState;
        this.scriptParameters = scriptParameters;
        this.scriptReader = new BufferedReader(scriptReader);
    }

    public String getNextStatement() {
        try {
            return this.getNextStatementImpl();
        }
        catch (IOException e) {
            throw new DbMaintainException("Unable to parse next statement from script.", e);
        }
    }

    protected String getNextStatementImpl() throws IOException {
        StatementBuilder statementBuilder = this.createStatementBuilder();
        if (this.currentChar == null) {
            this.currentChar = this.readNextCharacter();
        }
        while (!this.endOfScriptReached) {
            if (this.currentChar == null) {
                this.endOfScriptReached = true;
            }
            this.nextChar = this.readNextCharacter();
            statementBuilder.addCharacter(this.currentChar, this.nextChar);
            this.currentChar = this.nextChar;
            if (!statementBuilder.isComplete()) continue;
            if (statementBuilder.hasExecutableContent()) {
                return statementBuilder.buildStatement();
            }
            statementBuilder = this.createStatementBuilder();
        }
        if (!statementBuilder.isComplete() && statementBuilder.hasExecutableContent()) {
            throw new DbMaintainException("Last statement in script was not ended correctly.");
        }
        return null;
    }

    protected Character readNextCharacter() throws IOException {
        int charAsInt = this.scriptReader.read();
        return charAsInt == -1 ? null : Character.valueOf((char)charAsInt);
    }

    protected StatementBuilder createStatementBuilder() {
        return new StatementBuilder(this.initialParsingState, this.scriptParameters);
    }
}

