/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.DatabaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Databases {
    private Database defaultDatabase;
    private List<String> disabledDatabaseNames;
    private List<Database> databases;
    private Map<String, Database> nameDatabaseMap = new HashMap<String, Database>();

    public Databases(Database defaultDatabase, List<Database> databases, List<String> disabledDatabaseNames) {
        if (databases.isEmpty()) {
            throw new DatabaseException("Unable to configure databases. No database instances provided.");
        }
        this.databases = databases;
        this.defaultDatabase = defaultDatabase;
        for (Database database : databases) {
            this.nameDatabaseMap.put(database.getDatabaseName(), database);
        }
        this.disabledDatabaseNames = disabledDatabaseNames;
    }

    public Database getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public Database getDatabase(String databaseName) {
        if (this.isDisabledDatabase(databaseName)) {
            return null;
        }
        Database database = this.nameDatabaseMap.get(databaseName);
        if (database == null) {
            throw new DatabaseException("No database configured with name: " + databaseName);
        }
        return database;
    }

    public List<Database> getDatabases() {
        return this.databases;
    }

    public boolean isConfiguredDatabase(String databaseName) {
        return this.nameDatabaseMap.containsKey(databaseName) || this.isDisabledDatabase(databaseName);
    }

    public boolean isDisabledDatabase(String databaseName) {
        return this.disabledDatabaseNames.contains(databaseName);
    }
}

