/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dbmaintain.MainFactory;
import org.dbmaintain.config.ConfigUtils;
import org.dbmaintain.config.FactoryContext;
import org.dbmaintain.config.PropertyUtils;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.Databases;
import org.dbmaintain.database.SQLHandler;
import org.dbmaintain.script.parser.ScriptParserFactory;
import org.dbmaintain.structure.model.DbItemIdentifier;
import org.dbmaintain.structure.model.DbItemType;
import org.dbmaintain.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryWithDatabaseContext
extends FactoryContext {
    private Databases databases;
    private SQLHandler sqlHandler;

    public FactoryWithDatabaseContext(Properties configuration, MainFactory mainFactory, Databases databases, SQLHandler sqlHandler) {
        super(configuration, mainFactory);
        this.databases = databases;
        this.sqlHandler = sqlHandler;
    }

    public DbItemIdentifier getExecutedScriptsTable() {
        String executedScriptsTableName = PropertyUtils.getString("dbMaintainer.executedScriptsTableName", this.getConfiguration());
        Database defaultDatabase = this.databases.getDefaultDatabase();
        return DbItemIdentifier.getItemIdentifier(DbItemType.TABLE, defaultDatabase.getDefaultSchemaName(), executedScriptsTableName, defaultDatabase, true);
    }

    public Set<DbItemIdentifier> getSchemasToPreserve(String propertyPreserveSchemas) {
        HashSet<DbItemIdentifier> result = new HashSet<DbItemIdentifier>();
        List<String> schemasToPreserve = PropertyUtils.getStringList(propertyPreserveSchemas, this.getConfiguration());
        for (String schemaToPreserve : schemasToPreserve) {
            DbItemIdentifier itemIdentifier = DbItemIdentifier.parseSchemaIdentifier(schemaToPreserve, this.databases);
            if (itemIdentifier == null) continue;
            result.add(itemIdentifier);
        }
        return result;
    }

    public void addItemsToPreserve(DbItemType dbItemType, String itemsToPreserveProperty, Set<DbItemIdentifier> itemsToPreserve) {
        List<String> items = PropertyUtils.getStringList(itemsToPreserveProperty, this.getConfiguration());
        for (String itemToPreserve : items) {
            DbItemIdentifier itemIdentifier = DbItemIdentifier.parseItemIdentifier(dbItemType, itemToPreserve, this.databases);
            if (itemIdentifier == null) continue;
            itemsToPreserve.add(itemIdentifier);
        }
    }

    public Map<String, ScriptParserFactory> getDatabaseDialectScriptParserFactoryMap() {
        HashMap<String, ScriptParserFactory> databaseDialectScriptParserClassMap = new HashMap<String, ScriptParserFactory>();
        boolean backSlashEscapingEnabled = PropertyUtils.getBoolean("dbMaintainer.script.backSlashEscapingEnabled", this.getConfiguration());
        Properties scriptParameters = this.getScriptParameters();
        for (String databaseDialect : this.getDatabaseDialectsInUse()) {
            Class<ScriptParserFactory> scriptParserFactoryClass = ConfigUtils.getConfiguredClass(ScriptParserFactory.class, this.getConfiguration(), databaseDialect);
            ScriptParserFactory factory = ReflectionUtils.createInstanceOfType(scriptParserFactoryClass, false, new Class[]{Boolean.TYPE, Properties.class}, new Object[]{backSlashEscapingEnabled, scriptParameters});
            databaseDialectScriptParserClassMap.put(databaseDialect, factory);
        }
        return databaseDialectScriptParserClassMap;
    }

    protected Properties getScriptParameters() {
        String scriptParameterFile = PropertyUtils.getString("dbMaintainer.scriptParameterFile", null, this.getConfiguration());
        try {
            Properties scriptParameters = null;
            if (scriptParameterFile != null) {
                scriptParameters = new Properties();
                String scriptEncoding = PropertyUtils.getString("dbMaintainer.script.encoding", this.getConfiguration());
                scriptParameters.load(new InputStreamReader((InputStream)new FileInputStream(scriptParameterFile), scriptEncoding));
            }
            return scriptParameters;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load script parameter file " + scriptParameterFile, e);
        }
    }

    public Set<String> getDatabaseDialectsInUse() {
        HashSet<String> dialects = new HashSet<String>();
        for (Database database : this.databases.getDatabases()) {
            if (database == null) continue;
            dialects.add(database.getSupportedDatabaseDialect());
        }
        return dialects;
    }

    public Databases getDatabases() {
        return this.databases;
    }

    public SQLHandler getSqlHandler() {
        return this.sqlHandler;
    }
}

