CREATE TABLE entity_type_app_mapping (
    entity_type varchar2(32 char) NOT NULL,
    app_id varchar2(100 char) NOT NULL,
    ctime timestamp DEFAULT systimestamp NOT NULL,
    mtime timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT entity_type_app_map_pk PRIMARY KEY (entity_type),
    CONSTRAINT entity_type_app_map_etype_fk FOREIGN KEY (entity_type) REFERENCES entity_type_name(name) ON DELETE CASCADE,
    CONSTRAINT entity_type_app_map_app_id_fk FOREIGN KEY (app_id) REFERENCES app(id) ON DELETE CASCADE
);

INSERT INTO entity_type_app_mapping(entity_type, app_id)
    SELECT 'NETWORK', 'news' FROM DUAL WHERE EXISTS (
        select * from customer_category where customertype='standard');
INSERT INTO entity_type_app_mapping(entity_type, app_id)
    SELECT 'GROUP', 'news' FROM DUAL WHERE EXISTS (
        SELECT * FROM customer_category WHERE customertype='standard');
INSERT INTO entity_type_app_mapping(entity_type, app_id)
    SELECT 'APPOINTMENT', 'news' FROM DUAL WHERE EXISTS (
        SELECT * FROM customer_category WHERE customertype='standard');

COMMIT;
