CREATE SEQUENCE entity_status_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

-- define allowed status for an entity type
create table entity_status (
    id number(19) NOT NULL,
    entity_type varchar2(255) NOT NULL,
    status_name varchar2(255) NOT NULL,
    default_status char(1) DEFAULT ('f') NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT entity_status_pk PRIMARY KEY (id),
    CONSTRAINT entity_status_uq UNIQUE (entity_type, status_name)
);

-- who is allowed to to something depending on the entity status
create table entity_status_action (
    entity_status_id number(19) NOT NULL,
    authority varchar2(255),
    action varchar2(255),
    create_date timestamp DEFAULT systimestamp NOT NULL,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT entity_status_action_fk FOREIGN KEY (entity_status_id) REFERENCES entity_status(id) ON DELETE CASCADE
);


CREATE SEQUENCE entity_process_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;


-- assign business processes to an entity type in a specific state
create table entity_process (
    id number(19) NOT NULL,
    entity_status_id number(19) NOT NULL,
    process_definition varchar2(255),
    process_trigger varchar2(255),
    create_date timestamp DEFAULT systimestamp NOT NULL,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT entity_process_pk PRIMARY KEY (id),
    CONSTRAINT entity_process_status_fk FOREIGN KEY (entity_status_id) REFERENCES entity_status(id) ON DELETE CASCADE
);


-- mapping from entity status to process status
create table process_status_mapping (
    entity_process_id number(19) NOT NULL,
    entity_status_id number(19) NOT NULL,
    process_status varchar2(50),
    create_date timestamp DEFAULT systimestamp NOT NULL,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT process_status_process_id_fk FOREIGN KEY (entity_process_id) REFERENCES entity_process(id) ON DELETE CASCADE,
    CONSTRAINT process_status_status_fk FOREIGN KEY (entity_status_id) REFERENCES entity_status(id) ON DELETE CASCADE
);

COMMIT;