INSERT INTO version (id, release, name, type, description, "date")
VALUES (00002, '7.2', '00002_#patch_create-delete-action-table.sql', 'FEATURE', '#4853 Basis für "als gelöscht markieren"', now());

CREATE SEQUENCE delete_action_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE delete_action (
    id number(19,0) NOT NULL,
    person_id number(19,0) NOT NULL,
    item_id number(19,0) NOT NULL,
    item_type varchar2(4000 CHAR) NOT NULL,
    deleted_at TIMESTAMP DEFAULT systimestamp,
    transaction_id varchar2(4000 CHAR),
    CONSTRAINT delete_action_pk PRIMARY KEY (id)
);

CREATE OR REPLACE TRIGGER delete_action_bri 
    BEFORE INSERT ON delete_action
    FOR EACH ROW
DECLARE
    tn_id varchar2(4000 CHAR);
BEGIN
    tn_id := dbms_transaction.local_transaction_id(TRUE);
    :NEW.transaction_id := tn_id;
END;
/

COMMIT;
