INSERT INTO version (id, release, name, type, description, "date")
VALUES (01293, '6.11', '01293-6.11-create_search_index_queues.sql', 'FEATURE', 'Refactoring solr indexing: added event and index queue', systimestamp);

CREATE SEQUENCE search_index_queue_seq
    MINVALUE 0
    START WITH 0
    INCREMENT BY 1
    NOCACHE;

CREATE TABLE search_index_queue (
    id number(8) NOT NULL,
    item_id number(8) NOT NULL,
    item_type varchar2(32 CHAR) NOT NULL,
    created_at TIMESTAMP DEFAULT systimestamp  NOT NULL,
    CONSTRAINT search_index_queue_pk PRIMARY KEY (id)
);

CREATE SEQUENCE item_event_queue_seq
    MINVALUE 0
    START WITH 0
    INCREMENT BY 1
    NOCACHE;

CREATE TABLE item_event_queue (
    id number(8) NOT NULL,
    type varchar2(32 CHAR) NOT NULL,
    item_id number(8) NOT NULL,
    item_type varchar2(32 CHAR) NOT NULL,
    state varchar2(32 CHAR) NOT NULL,
    created_at TIMESTAMP DEFAULT systimestamp NOT NULL,
    CONSTRAINT item_event_queue_pk PRIMARY KEY (id)
);

COMMIT;
