INSERT INTO version (id, release, name, type, description, "date")
VALUES (01323, '6.14.0', 'fixes sequences', 'BUG', 'fixes #5059', systimestamp);

-- generic max('pTableField') of table 'pTableName'
CREATE OR REPLACE FUNCTION max_id(pTableName VARCHAR2, pTableField VARCHAR2)
    RETURN NUMBER
AS
      vCursorId      INTEGER := 0;
      vDummy         INTEGER := 0;
      vResult        NUMBER  := 0;
BEGIN
    vCursorId := DBMS_SQL.OPEN_CURSOR;
    DBMS_SQL.PARSE(vCursorId, 'SELECT MAX(' || pTableField || ') FROM ' || pTableName, DBMS_SQL.Native);
    DBMS_SQL.DEFINE_COLUMN(vCursorId, 1, vResult);
    vDummy := DBMS_SQL.EXECUTE(vCursorId);
    IF DBMS_SQL.FETCH_ROWS(vCursorId) > 0 THEN
        DBMS_SQL.COLUMN_VALUE(vCursorId, 1, vResult);
    END IF;
    DBMS_SQL.CLOSE_CURSOR(vCursorId);

    RETURN vResult;
END;
/

-- same syntax as postgresql's nextval, although the existing function nextval (existing per table) can't be overidden
-- also parsing and compiling within this function is not very performant
CREATE OR REPLACE FUNCTION next_val(pSequenceName VARCHAR2)
    RETURN NUMBER
AS
      vCursorId      INTEGER := 0;
      vDummy         INTEGER := 0;
      vResult        NUMBER := 0;
BEGIN
    vCursorId := DBMS_SQL.OPEN_CURSOR;
    DBMS_SQL.PARSE(vCursorId, 'SELECT ' || pSequenceName || '.nextVal FROM DUAL', DBMS_SQL.Native);
    DBMS_SQL.DEFINE_COLUMN(vCursorId, 1, vResult);
    vDummy := DBMS_SQL.EXECUTE(vCursorId);
    IF DBMS_SQL.FETCH_ROWS(vCursorId) > 0 THEN
        DBMS_SQL.COLUMN_VALUE(vCursorId, 1, vResult);
    END IF;
    DBMS_SQL.CLOSE_CURSOR(vCursorId);
    
    RETURN vResult;
END;
/

-- create function to create sequence with parameter for start
CREATE OR REPLACE FUNCTION update_sequence (table_name varchar2, id_column varchar2, sequence_name varchar2)
    RETURN NUMBER
AS
    maxValue NUMBER;
    curValue NUMBER;
BEGIN
    maxValue := max_id(table_name, id_column);
    curValue := next_val(sequence_name);
    --increase sequence while there are still higher id's found in the table
    WHILE curValue < maxValue
    LOOP
       curValue := next_val(sequence_name);
    END LOOP;

    RETURN curValue;
END;
/

SELECT update_sequence('entity_nav_link', 'id', 'entity_nav_link_seq') FROM dual;
SELECT update_sequence('entity', 'id', 'entity_seq') FROM dual;
SELECT update_sequence('mdl_album_image', 'id', 'mdl_album_image_seq') FROM dual;
SELECT update_sequence('mdl_album', 'id', 'mdl_album_seq') FROM dual;
SELECT update_sequence('mdl_comment', 'id', 'mdl_comment_seq') FROM dual;
SELECT update_sequence('mdl_document', 'id', 'mdl_document_seq') FROM dual;
SELECT update_sequence('mdl_document_version', 'id', 'mdl_document_version_seq') FROM dual;
SELECT update_sequence('mdl_forum_topic_article', 'id', 'mdl_forum_topic_article_seq') FROM dual;
SELECT update_sequence('mdl_forum_topic', 'id', 'mdl_forum_topic_seq') FROM dual;
SELECT update_sequence('mdl_video_link', 'id', 'mdl_video_link_seq') FROM dual;
SELECT update_sequence('message', 'id', 'message_seq') FROM dual;
SELECT update_sequence('news_blog', 'id', 'news_blog_seq') FROM dual;
SELECT update_sequence('person', 'id', 'person_seq') FROM dual;
SELECT update_sequence('raweditor_version', 'raweditor_id', 'raweditor_seq') FROM dual;
SELECT update_sequence('raweditor_version', 'id', 'raweditor_version_seq') FROM dual;
SELECT update_sequence('school', 'id', 'school_seq') FROM dual;
SELECT update_sequence('base_property', 'id', 'seq_base_property') FROM dual;
SELECT update_sequence('domain_property', 'id', 'seq_domain_property') FROM dual;
SELECT update_sequence('survey_predefined_answer', 'id', 'survey_predefined_answer_seq') FROM dual;
SELECT update_sequence('survey_question', 'id', 'survey_question_seq') FROM dual;
SELECT update_sequence('survey', 'id', 'survey_seq') FROM dual;
SELECT update_sequence('university', 'id', 'university_seq') FROM dual;
SELECT update_sequence('user_setting', 'id', 'user_setting_seq') FROM dual;
SELECT update_sequence('wiki_editor', 'id', 'wiki_editor_seq') FROM dual;
SELECT update_sequence('wiki_editor_version', 'id', 'wiki_editor_version_seq') FROM dual;
SELECT update_sequence('workstream_entry', 'id', 'workstream_entry_seq') FROM dual;

DROP FUNCTION update_sequence;
DROP FUNCTION next_val;
DROP FUNCTION max_id;

COMMIT;