/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.executedscriptinfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dbmaintain.util.DbMaintainException;
import thirdparty.org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptIndexes
implements Comparable<ScriptIndexes> {
    private List<Long> indexes = new ArrayList<Long>();

    public ScriptIndexes(List<Long> indexes) {
        this.indexes = indexes;
        this.assertValidIndexes();
    }

    public ScriptIndexes(String indexString) {
        this.indexes = this.extractIndexes(indexString);
        this.assertValidIndexes();
    }

    public List<Long> getIndexes() {
        return this.indexes;
    }

    public boolean isIncrementalScript() {
        return !this.indexes.isEmpty() && this.indexes.get(this.indexes.size() - 1) != null;
    }

    public boolean isRepeatableScript() {
        return !this.isIncrementalScript();
    }

    protected void assertValidIndexes() {
        if (this.isRepeatableScript()) {
            for (Long index : this.indexes) {
                if (index == null) continue;
                throw new DbMaintainException("Repeatable scripts cannot be located inside an indexed folder.");
            }
        }
    }

    public String getIndexesString() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Long index : this.indexes) {
            if (first) {
                first = false;
            } else {
                result.append('.');
            }
            if (index == null) {
                result.append('x');
                continue;
            }
            result.append(index);
        }
        return result.toString();
    }

    protected List<Long> extractIndexes(String indexString) {
        String[] parts;
        ArrayList<Long> result = new ArrayList<Long>();
        if (StringUtils.isEmpty(indexString)) {
            return result;
        }
        for (String part : parts = StringUtils.split(indexString, '.')) {
            if ("x".equalsIgnoreCase(part)) {
                result.add(null);
                continue;
            }
            result.add(new Long(part));
        }
        return result;
    }

    public String toString() {
        return "indexes: " + this.getIndexesString();
    }

    @Override
    public int compareTo(ScriptIndexes otherVersion) {
        List<Long> otherIndexes = otherVersion.getIndexes();
        if (this.indexes.isEmpty()) {
            if (otherIndexes.isEmpty()) {
                return 0;
            }
            return -1;
        }
        if (otherIndexes.isEmpty()) {
            return 1;
        }
        Iterator<Long> thisIterator = this.indexes.iterator();
        Iterator<Long> otherIterator = otherIndexes.iterator();
        while (thisIterator.hasNext() && otherIterator.hasNext()) {
            Long thisIndex = thisIterator.next();
            Long otherIndex = otherIterator.next();
            if (thisIndex != null && otherIndex != null) {
                if (thisIndex < otherIndex) {
                    return -1;
                }
                if (thisIndex <= otherIndex) continue;
                return 1;
            }
            if (thisIndex != null) {
                return -1;
            }
            if (otherIndex == null) continue;
            return 1;
        }
        if (!thisIterator.hasNext() && !otherIterator.hasNext()) {
            return 0;
        }
        if (thisIterator.hasNext()) {
            return 1;
        }
        return -1;
    }

    public int hashCode() {
        return 31 + (this.indexes == null ? 0 : ((Object)this.indexes).hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ScriptIndexes other = (ScriptIndexes)object;
        return !(this.indexes == null ? other.indexes != null : !((Object)this.indexes).equals(other.indexes));
    }
}

