/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.archive.impl;

import java.io.File;
import java.util.Set;
import java.util.SortedSet;
import org.dbmaintain.script.Script;
import org.dbmaintain.script.archive.ScriptArchiveCreator;
import org.dbmaintain.script.executedscriptinfo.ScriptIndexes;
import org.dbmaintain.script.qualifier.Qualifier;
import org.dbmaintain.script.repository.ScriptRepository;
import org.dbmaintain.script.repository.impl.ArchiveScriptLocation;
import org.dbmaintain.util.DbMaintainException;
import thirdparty.org.apache.commons.lang.StringUtils;
import thirdparty.org.apache.commons.logging.Log;
import thirdparty.org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptArchiveCreator
implements ScriptArchiveCreator {
    private static Log logger = LogFactory.getLog(DefaultScriptArchiveCreator.class);
    protected ScriptRepository scriptRepository;
    protected String scriptEncoding;
    protected String postProcessingScriptDirName;
    protected Set<Qualifier> registeredQualifiers;
    protected Set<Qualifier> patchQualifiers;
    protected String scriptIndexRegexp;
    protected String qualifierRegexp;
    protected String targetDatabaseRegexp;
    protected Set<String> scriptFileExtensions;
    protected ScriptIndexes baseLineRevision;
    protected boolean ignoreCarriageReturnsWhenCalculatingCheckSum;

    public DefaultScriptArchiveCreator(ScriptRepository scriptRepository, String scriptEncoding, String postProcessingScriptDirName, Set<Qualifier> registeredQualifiers, Set<Qualifier> patchQualifiers, String scriptIndexRegexp, String qualifierRegexp, String targetDatabaseRegexp, Set<String> scriptFileExtensions, ScriptIndexes baseLineRevision, boolean ignoreCarriageReturnsWhenCalculatingCheckSum) {
        this.scriptRepository = scriptRepository;
        this.scriptEncoding = scriptEncoding;
        this.postProcessingScriptDirName = postProcessingScriptDirName;
        this.registeredQualifiers = registeredQualifiers;
        this.patchQualifiers = patchQualifiers;
        this.scriptIndexRegexp = scriptIndexRegexp;
        this.qualifierRegexp = qualifierRegexp;
        this.targetDatabaseRegexp = targetDatabaseRegexp;
        this.scriptFileExtensions = scriptFileExtensions;
        this.baseLineRevision = baseLineRevision;
        this.ignoreCarriageReturnsWhenCalculatingCheckSum = ignoreCarriageReturnsWhenCalculatingCheckSum;
    }

    @Override
    public void createScriptArchive(String archiveFileName) {
        if (StringUtils.isBlank(archiveFileName)) {
            throw new DbMaintainException("Unable to create script archive. No archive file name was specified.");
        }
        try {
            logger.info("Creating script archive: " + archiveFileName);
            SortedSet<Script> allScripts = this.scriptRepository.getAllScripts();
            ArchiveScriptLocation archiveScriptLocation = new ArchiveScriptLocation(allScripts, this.scriptEncoding, this.postProcessingScriptDirName, this.registeredQualifiers, this.patchQualifiers, this.scriptIndexRegexp, this.qualifierRegexp, this.targetDatabaseRegexp, this.scriptFileExtensions, this.baseLineRevision, this.ignoreCarriageReturnsWhenCalculatingCheckSum);
            archiveScriptLocation.writeToJarFile(new File(archiveFileName));
        }
        catch (Exception e) {
            throw new DbMaintainException("Error creating script archive " + archiveFileName, e);
        }
    }
}

