/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.launch.task;

import org.dbmaintain.MainFactory;
import org.dbmaintain.launch.task.DbMaintainTask;
import org.dbmaintain.launch.task.TaskConfiguration;
import org.dbmaintain.script.archive.ScriptArchiveCreator;

public class CreateScriptArchiveTask
extends DbMaintainTask {
    protected String archiveFileName;
    protected String scriptLocations;
    protected String scriptEncoding;
    protected String postProcessingScriptDirectoryName;
    protected String qualifiers;
    protected String patchQualifiers;
    protected String scriptFileExtensions;

    public CreateScriptArchiveTask() {
    }

    public CreateScriptArchiveTask(String archiveFileName, String scriptLocations, String scriptEncoding, String postProcessingScriptDirectoryName, String qualifiers, String patchQualifiers, String scriptFileExtensions) {
        this.archiveFileName = archiveFileName;
        this.scriptLocations = scriptLocations;
        this.scriptEncoding = scriptEncoding;
        this.postProcessingScriptDirectoryName = postProcessingScriptDirectoryName;
        this.qualifiers = qualifiers;
        this.patchQualifiers = patchQualifiers;
        this.scriptFileExtensions = scriptFileExtensions;
    }

    public boolean doExecute(MainFactory mainFactory) {
        ScriptArchiveCreator scriptArchiveCreator = mainFactory.createScriptArchiveCreator();
        scriptArchiveCreator.createScriptArchive(this.archiveFileName);
        return true;
    }

    protected void addTaskConfiguration(TaskConfiguration taskConfiguration) {
        taskConfiguration.addConfigurationIfSet("dbMaintainer.script.locations", this.scriptLocations);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.script.encoding", this.scriptEncoding);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.postProcessingScript.directoryName", this.postProcessingScriptDirectoryName);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.qualifiers", this.qualifiers);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.script.patch.qualifiers", this.patchQualifiers);
        taskConfiguration.addConfigurationIfSet("dbMaintainer.script.fileExtensions", this.scriptFileExtensions);
    }

    public void setArchiveFileName(String archiveFileName) {
        this.archiveFileName = archiveFileName;
    }

    public void setScriptLocations(String scriptLocations) {
        this.scriptLocations = scriptLocations;
    }

    public void setScriptEncoding(String scriptEncoding) {
        this.scriptEncoding = scriptEncoding;
    }

    public void setPostProcessingScriptDirectoryName(String postProcessingScriptDirectoryName) {
        this.postProcessingScriptDirectoryName = postProcessingScriptDirectoryName;
    }

    public void setQualifiers(String qualifiers) {
        this.qualifiers = qualifiers;
    }

    public void setPatchQualifiers(String patchQualifiers) {
        this.patchQualifiers = patchQualifiers;
    }

    public void setScriptFileExtensions(String scriptFileExtensions) {
        this.scriptFileExtensions = scriptFileExtensions;
    }
}

