/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.DatabaseConnection;
import org.dbmaintain.database.DatabaseException;
import org.dbmaintain.database.IdentifierProcessor;
import org.dbmaintain.database.SQLHandler;
import thirdparty.org.apache.commons.dbutils.DbUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyDatabase
extends Database {
    public DerbyDatabase(DatabaseConnection databaseConnection, IdentifierProcessor identifierProcessor) {
        super(databaseConnection, identifierProcessor);
    }

    @Override
    public String getSupportedDatabaseDialect() {
        return "derby";
    }

    @Override
    public Set<String> getTableNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select t.TABLENAME from SYS.SYSTABLES t, SYS.SYSSCHEMAS  s where t.TABLETYPE = 'T' AND t.SCHEMAID = s.SCHEMAID AND s.SCHEMANAME = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getColumnNames(String schemaName, String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select c.COLUMNNAME from SYS.SYSCOLUMNS c, SYS.SYSTABLES t, SYS.SYSSCHEMAS s where c.REFERENCEID = t.TABLEID and t.TABLENAME = '" + tableName + "' AND t.SCHEMAID = s.SCHEMAID AND s.SCHEMANAME = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getViewNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select t.TABLENAME from SYS.SYSTABLES t, SYS.SYSSCHEMAS s where t.TABLETYPE = 'V' AND t.SCHEMAID = s.SCHEMAID AND s.SCHEMANAME = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getSynonymNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select t.TABLENAME from SYS.SYSTABLES t, SYS.SYSSCHEMAS s where t.TABLETYPE = 'A' AND t.SCHEMAID = s.SCHEMAID AND s.SCHEMANAME = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getTriggerNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select t.TRIGGERNAME from SYS.SYSTRIGGERS t, SYS.SYSSCHEMAS s where t.SCHEMAID = s.SCHEMAID AND s.SCHEMANAME = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getIdentityColumnNames(String schemaName, String tableName) {
        return this.getPrimaryKeyColumnNames(schemaName, tableName);
    }

    @Override
    public void incrementIdentityColumnToValue(String schemaName, String tableName, String identityColumnName, long identityValue) {
        this.getSQLHandler().execute("alter table " + this.qualified(schemaName, tableName) + " alter column " + this.quoted(identityColumnName) + " RESTART WITH " + identityValue, this.getDataSource());
    }

    @Override
    public void disableReferentialConstraints(String schemaName) {
        Set<String> tableNames = this.getTableNames(schemaName);
        for (String tableName : tableNames) {
            this.disableReferentialConstraints(schemaName, tableName);
        }
    }

    protected void disableReferentialConstraints(String schemaName, String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select c.CONSTRAINTNAME from SYS.SYSCONSTRAINTS c, SYS.SYSTABLES t, SYS.SYSSCHEMAS s where c.TYPE = 'F' AND c.TABLEID = t.TABLEID  AND t.TABLENAME = '" + tableName + "' AND t.SCHEMAID = s.SCHEMAID AND s.SCHEMANAME = '" + schemaName + "'", this.getDataSource());
        for (String constraintName : constraintNames) {
            sqlHandler.execute("alter table " + this.qualified(schemaName, tableName) + " drop constraint " + this.quoted(constraintName), this.getDataSource());
        }
    }

    @Override
    public void disableValueConstraints(String schemaName) {
        Set<String> tableNames = this.getTableNames(schemaName);
        for (String tableName : tableNames) {
            this.disableValueConstraints(schemaName, tableName);
        }
    }

    protected void disableValueConstraints(String schemaName, String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select c.CONSTRAINTNAME from SYS.SYSCONSTRAINTS c, SYS.SYSTABLES t, SYS.SYSSCHEMAS s where c.TYPE in ('U', 'C') AND c.TABLEID = t.TABLEID  AND t.TABLENAME = '" + tableName + "' AND t.SCHEMAID = s.SCHEMAID AND s.SCHEMANAME = '" + schemaName + "'", this.getDataSource());
        for (String constraintName : constraintNames) {
            sqlHandler.execute("alter table " + this.qualified(schemaName, tableName) + " drop constraint " + this.quoted(constraintName), this.getDataSource());
        }
        Set<String> primaryKeyColumnNames = this.getPrimaryKeyColumnNames(schemaName, tableName);
        Set<String> notNullColumnNames = this.getNotNullColummnNames(schemaName, tableName);
        for (String notNullColumnName : notNullColumnNames) {
            if (primaryKeyColumnNames.contains(notNullColumnName)) continue;
            sqlHandler.execute("alter table " + this.qualified(schemaName, tableName) + " alter column " + this.quoted(notNullColumnName) + " NULL", this.getDataSource());
        }
    }

    @Override
    public void setDatabaseDefaultSchema() {
        this.getSQLHandler().execute("set schema " + this.getDefaultSchemaName(), this.getDataSource());
    }

    @Override
    public void setSettingIdentityColumnValueEnabled(String schemaName, String tableName, boolean enabled) {
    }

    @Override
    public boolean supportsSynonyms() {
        return true;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsIdentityColumns() {
        return true;
    }

    @Override
    public boolean supportsSetDatabaseDefaultSchema() {
        return true;
    }

    protected Set<String> getPrimaryKeyColumnNames(String schemaName, String tableName) {
        HashSet<String> hashSet;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = this.getDataSource().getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getPrimaryKeys(null, schemaName, tableName);
            HashSet<String> result = new HashSet<String>();
            while (resultSet.next()) {
                result.add(resultSet.getString(4));
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to get primary key column names for schema name: " + schemaName + ", table name: " + tableName, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, null, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, null, resultSet);
        return hashSet;
    }

    protected Set<String> getNotNullColummnNames(String schemaName, String tableName) {
        HashSet<String> hashSet;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = this.getDataSource().getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getColumns(null, schemaName, tableName, "%");
            HashSet<String> result = new HashSet<String>();
            while (resultSet.next()) {
                if (resultSet.getInt(11) != 0) continue;
                result.add(resultSet.getString(4));
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to get not null column names for schema name: " + schemaName + ", table name: " + tableName, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, null, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, null, resultSet);
        return hashSet;
    }
}

