/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.connect.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import de.justsoftware.app.connect.api.model.BreadcrumbItem;
import de.justsoftware.app.connect.api.model.EntityComponentModel;
import de.justsoftware.app.connect.api.model.EntityEditTab;
import de.justsoftware.app.connect.api.model.EntityTab;
import de.justsoftware.app.connect.api.model.EntityVersionInfo;
import de.justsoftware.onx.container.shared.model.EntityId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Entity {
    private final EntityId _id;
    private final EntityVersionInfo _version;
    private final String _name;
    private final String _type;
    private final EntityTab _defaultTab;
    private final ImmutableList<EntityTab> _availableTabs;
    private final ListMultimap<String, EntityComponentModel> _components;
    private final ImmutableList<BreadcrumbItem> _breadcrumb;
    private final ImmutableSet<EntityEditTab> _editTabs;
    private final ImmutableSet<String> _permissions;
    private final boolean _visible;
    private final DateWithoutTimezone _startAt;
    private final DateWithoutTimezone _endAt;
    private final String _location;
    private final String _timezone;

    @JsonCreator
    public Entity(@JsonProperty(value="id", required=true) EntityId id, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="type", required=true) String type, @JsonProperty(value="defaultTab", required=true) EntityTab defaultTab, @JsonProperty(value="availableTabs", required=true) ImmutableList<EntityTab> availableTabs, @JsonProperty(value="components", required=true) ListMultimap<String, EntityComponentModel> components, @JsonProperty(value="breadcrumb", required=true) ImmutableList<BreadcrumbItem> breadcrumb, @JsonProperty(value="editTabs", required=true) ImmutableSet<EntityEditTab> editTabs, @JsonProperty(value="permissions", required=true) ImmutableSet<String> permissions, @JsonProperty(value="visible", required=true) boolean visible, @Nullable @JsonProperty(value="version", required=false) EntityVersionInfo version, @Nullable @JsonProperty(value="startAt", required=false) DateWithoutTimezone startAt, @Nullable @JsonProperty(value="endAt", required=false) DateWithoutTimezone endAt, @Nullable @JsonProperty(value="location", required=false) String location, @Nullable @JsonProperty(value="timezone", required=false) String timezone) {
        this._id = id;
        this._version = version;
        this._name = name;
        this._type = type;
        this._defaultTab = defaultTab;
        this._availableTabs = availableTabs;
        this._components = components;
        this._breadcrumb = breadcrumb;
        this._editTabs = editTabs;
        this._permissions = permissions;
        this._visible = visible;
        this._startAt = startAt;
        this._endAt = endAt;
        this._location = location;
        this._timezone = timezone;
    }

    @Nonnull
    public EntityId getId() {
        return this._id;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public String getType() {
        return this._type;
    }

    @Nonnull
    public EntityTab getDefaultTab() {
        return this._defaultTab;
    }

    @Nonnull
    public ImmutableList<EntityTab> getAvailableTabs() {
        return this._availableTabs;
    }

    @Nonnull
    public ListMultimap<String, EntityComponentModel> getComponents() {
        return this._components;
    }

    @Nonnull
    public ImmutableList<BreadcrumbItem> getBreadcrumb() {
        return this._breadcrumb;
    }

    @Nonnull
    public ImmutableSet<EntityEditTab> getEditTabs() {
        return this._editTabs;
    }

    @Nonnull
    public ImmutableSet<String> getPermissions() {
        return this._permissions;
    }

    public boolean isVisible() {
        return this._visible;
    }

    @CheckForNull
    public EntityVersionInfo getVersion() {
        return this._version;
    }

    @CheckForNull
    public DateWithoutTimezone getStartAt() {
        return this._startAt;
    }

    @CheckForNull
    public DateWithoutTimezone getEndAt() {
        return this._endAt;
    }

    @CheckForNull
    public String getLocation() {
        return this._location;
    }

    @CheckForNull
    public String getTimezone() {
        return this._timezone;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this._id).add("name", (Object)this._name).add("type", (Object)this._type).add("defaultTab", (Object)this._defaultTab).add("availableTabs", this._availableTabs).add("components", this._components).add("breadcrumb", this._breadcrumb).add("editTabs", this._editTabs).add("permissions", this._permissions).add("visible", this._visible).add("version", (Object)this._version).add("startAt", (Object)this._startAt).add("endAt", (Object)this._endAt).add("location", (Object)this._location).add("timezone", (Object)this._timezone).toString();
    }
}

