/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.connect.api.controller.support;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import de.justsoftware.app.connect.api.model.JustConnectError;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolationException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.util.HtmlUtils;

@ControllerAdvice(basePackages={"de.justsoftware.app.connect.api"})
@ParametersAreNonnullByDefault
public class JustConnectExceptionHandlingControllerAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(JustConnectExceptionHandlingControllerAdvice.class);

    @ExceptionHandler(value={PermissionDeniedException.class})
    @Nonnull
    public ResponseEntity<JustConnectError> handlePermissionDeniedException(Throwable t) {
        LOG.debug("permission denied", t);
        return this.createJustConnectError(t, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={NotLoggedInException.class})
    @Nonnull
    public ResponseEntity<JustConnectError> handleNotLoggedInException(NotLoggedInException e) {
        LOG.debug("unauthorized", (Throwable)e);
        return this.createJustConnectError((Throwable)e, HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class, InvalidIdServiceException.class, JucoConstraintViolationException.class})
    @Nonnull
    public ResponseEntity<JustConnectError> handleHttpMessageNotReadableException(Throwable t) {
        LOG.debug("invalid http message", t);
        return this.createJustConnectError(t, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Throwable.class})
    @Nonnull
    public ResponseEntity<JustConnectError> handleThrowable(Throwable t) {
        LOG.error("some unexpected error happened: ", t);
        return this.createJustConnectError(t, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Nonnull
    private ResponseEntity<JustConnectError> createJustConnectError(Throwable t, HttpStatus status) {
        return new ResponseEntity((Object)new JustConnectError(t.getClass().getSimpleName() + ": " + HtmlUtils.htmlEscape((String)t.getMessage())), status);
    }
}

