/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.connect.api.controller;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.app.connect.api.model.BreadcrumbItem;
import de.justsoftware.app.connect.api.model.Entity;
import de.justsoftware.app.connect.api.model.EntityComponentModel;
import de.justsoftware.app.connect.api.model.EntityConfiguration;
import de.justsoftware.app.connect.api.model.EntityEditTab;
import de.justsoftware.app.connect.api.model.EntitySubscriptionModel;
import de.justsoftware.app.connect.api.model.EntityTab;
import de.justsoftware.app.connect.api.model.EntityVersionInfo;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.common.shared.model.ComponentModel;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.NameAndParam;
import de.justsoftware.onx.common.shared.model.OptionsItem;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.Actions;
import de.justsoftware.onx.common.shared.model.action.DynamicAction;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.action.StaticItemAction;
import de.justsoftware.onx.common.shared.model.action.TabNameForConfiguration;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.ComponentTypeVisitor;
import de.justsoftware.onx.common.shared.model.component.DefaultComponentTypeVisitor;
import de.justsoftware.onx.common.shared.model.component.DynamicComponentType;
import de.justsoftware.onx.common.shared.model.component.DynamicComponentTypeCreator;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.MyContentsService;
import de.justsoftware.onx.container.business.BreadcrumbService;
import de.justsoftware.onx.container.business.EntityDetailsService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.shared.model.BreadCrumbViewData;
import de.justsoftware.onx.container.shared.model.ComponentPosition;
import de.justsoftware.onx.container.shared.model.ComponentPositionConfig;
import de.justsoftware.onx.container.shared.model.DynamicEntityTabCreator;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityDetailsNotVisibleException;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityTabVisitor;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.MyContentEntity;
import de.justsoftware.onx.container.shared.model.StaticEntityTab;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityLinkedEntityPrivacy;
import de.justsoftware.onx.container.shared.model.util.EntityTabUtils;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeCountType;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(path={"/connect/api/v1/entity"})
@Api(tags={"Entity"})
public class ConnectEntityController {
    private static final String COMPONENT_POSITION_TOP = "TOP";
    private static final String COMPONENT_POSITION_LEFT = "LEFT";
    private static final String COMPONENT_POSITION_RIGHT = "RIGHT";
    private final EntityDetailsService _entityDetailsService;
    private final EntityService _entityService;
    private final EntityConfigService _configService;
    private final BreadcrumbService _breadcrumbService;
    private final EntityVersionService _entityVersionService;
    private final MyContentsService _myContentsService;

    @Autowired
    public ConnectEntityController(EntityConfigService configService, EntityDetailsService entityDetailsService, BreadcrumbService breadcrumbService, EntityService entityService, EntityVersionService entityVersionService, MyContentsService myContentsService) {
        this._entityDetailsService = entityDetailsService;
        this._configService = configService;
        this._breadcrumbService = breadcrumbService;
        this._entityService = entityService;
        this._entityVersionService = entityVersionService;
        this._myContentsService = myContentsService;
    }

    @Nonnull
    @RequestMapping(method={RequestMethod.GET}, path={"/{entityId}"}, produces={"application/json"})
    @ApiOperation(value="get data of one entity", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns entity data"), @ApiResponse(code=404, message="error - entity not found"), @ApiResponse(code=400, message="error - invalid id"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public Entity getEntity(@PathVariable(value="entityId") EntityId entityId, @Nullable @RequestParam(value="layoutEntity", required=false) EntityId layoutEntityId, @AuthorizedContext AuthorizationContext authContext) {
        BreadCrumbViewData breadcrumbLinks = this._breadcrumbService.breadcrumb((GlobalId)entityId, entityId, layoutEntityId, (AuthorizationCheckContextWithLocale)authContext);
        ImmutableList breadcrumb = (ImmutableList)breadcrumbLinks.getParents().stream().map(l -> new BreadcrumbItem(Strings.nullToEmpty((String)l.getLink().getText()), l.getLink().getHrefOrEmpty())).collect(ImmutableList.toImmutableList());
        try {
            EntityDetails entity = this._entityDetailsService.getDetailsById(entityId, authContext);
            ImmutableList entityTabs = this._configService.getEntityTabOrderForEntityType(entity.getType());
            EntityTab defaultTab = this.createTab(entity, EntityTabUtils.getSelectedDefaultTab((ImmutableList)entityTabs, (de.justsoftware.onx.container.shared.model.EntityTab)entity.getDefaultTab())).get();
            ImmutableList availableTabs = (ImmutableList)entityTabs.stream().map(t -> this.createTab(entity, (de.justsoftware.onx.container.shared.model.EntityTab)t).orElse(null)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
            ImmutableSet<EntityEditTab> visibleEditTabs = this.getVisibleEntityEditTabs(entity);
            ImmutableSet<Action> permissions = this.getPermissions(entity, authContext);
            ImmutableSet permissionAsString = permissions.stream().map(action -> DynamicAction.class.isInstance(action) ? action.getName() + ":" + ((DynamicAction)DynamicAction.class.cast(action)).getParameter() : action.getName()).collect(Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf));
            TimeZone timezone = entity.getTimeZone();
            return new Entity(entity.getId(), entity.getName(), entity.getType().getName(), defaultTab, (ImmutableList<EntityTab>)availableTabs, this.getEntityComponents(entity), (ImmutableList<BreadcrumbItem>)breadcrumb, visibleEditTabs, (ImmutableSet<String>)permissionAsString, true, this.getVersionInfo(entity), entity.getStartAt(), entity.getEndAt(), entity.getLocation(), timezone != null ? timezone.getDisplayString() : null);
        }
        catch (EntityDetailsNotVisibleException e) {
            EntityTab defaultTab = new EntityTab(StaticEntityTab.DASHBOARD.getName(), null, IconType.TH_LARGE.name(), true);
            return new Entity(e.getId(), e.getName(), e.getType().getName(), defaultTab, (ImmutableList<EntityTab>)ImmutableList.of(), (ListMultimap<String, EntityComponentModel>)ImmutableListMultimap.of(), (ImmutableList<BreadcrumbItem>)breadcrumb, (ImmutableSet<EntityEditTab>)ImmutableSet.of(), (ImmutableSet<String>)ImmutableSet.of(), false, null, null, null, null, null);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/subscriptions"}, produces={"application/json"})
    @ApiOperation(value="gets all entities of given type a user liked", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns configuration"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public ImmutableList<EntitySubscriptionModel> getLikedEntities(@RequestParam(value="type") Set<EntityType> types, @RequestParam(value="teaserCount", required=false, defaultValue="50") int teaserCount, @AuthorizedContext AuthorizationContext authContext) {
        ImmutableList subscriptionsByTypes = this._myContentsService.getSubscriptionsByTypes((Set)ImmutableSet.copyOf(types), teaserCount, authContext);
        ImmutableSetMultimap<ItemId, Action> permissionsForSubscriptions = this.getPermissionsForSubscriptions(authContext, (ImmutableList<MyContentEntity>)subscriptionsByTypes);
        return (ImmutableList)subscriptionsByTypes.stream().map(subscription -> EntitySubscriptionModel.from(subscription, (ImmutableSet<Action>)permissionsForSubscriptions.get((Object)subscription.getId()))).filter(subscriptionModel -> !subscriptionModel.getPermissions().isEmpty()).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private ImmutableSetMultimap<ItemId, Action> getPermissionsForSubscriptions(AuthorizationContext authContext, ImmutableList<MyContentEntity> subscriptionsByTypes) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        subscriptionsByTypes.forEach(myContentEntity -> builder.putAll((Object)myContentEntity.getId(), (Object[])new Action[]{StaticItemAction.UNLIKE_UNSUBSCRIBE, StaticItemAction.LIKE_SUBSCRIBE, StaticItemAction.LIKE_SUBSCRIBE_READ}));
        return authContext.may((SetMultimap)builder.build());
    }

    @CheckForNull
    private EntityVersionInfo getVersionInfo(EntityDetails entity) {
        EntityVersionClientModel evcm = entity.getVersion();
        if (evcm == null) {
            return null;
        }
        EntityVersionClientModel publicVersion = entity.getLastPublicVersion();
        EntityVersionId compareVersion = publicVersion != null ? publicVersion.getId() : (EntityVersionId)InvalidIdServiceException.check((Object)this._entityVersionService.getFirstVersionForEntity(entity.getId()));
        ImmutableSet changedComponents = FluentIterable.from((Iterable)this._entityVersionService.getChangedComponents(compareVersion, evcm.getId())).transform(ConnectEntityController::toEntityVersionComponent).filter(Predicates.notNull()).toSet();
        return new EntityVersionInfo(evcm.getId(), evcm.getVersionString(), evcm.getAuthorId(), evcm.getChangeMessage(), evcm.getStatus().getName(), evcm.getVersionType(), this.toDateTime(evcm.getReleaseDate()), this.toDateTime(evcm.getExpirationDate()), (ImmutableSet<EntityVersionInfo.EntityVersionComponent>)changedComponents);
    }

    @CheckForNull
    private static EntityVersionInfo.EntityVersionComponent toEntityVersionComponent(ComponentType type) {
        return ((Optional)type.accept((ComponentTypeVisitor)new DefaultComponentTypeVisitor<Optional<EntityVersionInfo.EntityVersionComponent>>(){

            protected Optional<EntityVersionInfo.EntityVersionComponent> visitDefault() {
                return Optional.empty();
            }

            public Optional<EntityVersionInfo.EntityVersionComponent> visitMultiWiki() {
                return Optional.of(EntityVersionInfo.EntityVersionComponent.CONTENT);
            }

            public Optional<EntityVersionInfo.EntityVersionComponent> visitDocument() {
                return Optional.of(EntityVersionInfo.EntityVersionComponent.FILES);
            }
        })).orElse(null);
    }

    @CheckForNull
    private DateTime toDateTime(@Nullable DateWithoutTimezone date) {
        return date != null ? new DateTime(date.getTime()) : null;
    }

    @Nonnull
    @RequestMapping(method={RequestMethod.GET}, path={"/configuration"}, produces={"application/json"})
    @ApiOperation(value="get configuration for entity types", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - returns configuration"), @ApiResponse(code=404, message="error - unable to load configuration"), @ApiResponse(code=400, message="error - unable to load configuration"), @ApiResponse(code=500, message="fatal error - some internal error")})
    public ImmutableMap<EntityType, EntityConfiguration> getConfiguration() {
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        ImmutableSet entityTypes = this._configService.getOrderedActivatedEntityTypes();
        for (EntityType type : entityTypes) {
            long tabCount = this._configService.getEntityTabCountForEntityType(type);
            String icon = this._configService.icon(type).name();
            boolean iconVisibleOnHeader = this._configService.isIconVisibleOnHeader(type);
            boolean showTabCounts = this._configService.showTabCounts(type);
            boolean releaseProcessMandatory = this._configService.releaseProcessMandatory(type);
            resultBuilder.put((Object)type, (Object)new EntityConfiguration(tabCount, icon, iconVisibleOnHeader, showTabCounts, releaseProcessMandatory));
        }
        return resultBuilder.build();
    }

    @Nonnull
    private ImmutableSet<EntityEditTab> getVisibleEntityEditTabs(EntityDetails entity) {
        if (!entity.getMay().contains((Object)StaticEntityAction.ENTITY_MODIFY)) {
            return ImmutableSet.of();
        }
        Sets.SetView tabPermissions = Sets.intersection((Set)entity.getMay(), (Set)Actions.ENTITY_EDIT_TAB_ACTIONS);
        ImmutableMap<EntityType, DBEntityLinkedEntityPrivacy> entityLinkedPrivacy = this.findPrivacyData(entity);
        EntityEditTabVisibilityVisitor tabVisibilityVisitor = new EntityEditTabVisibilityVisitor(entity.getType(), (Set<? extends Action>)tabPermissions, entityLinkedPrivacy);
        return FluentIterable.from((Object[])EntityEditTab.values()).filter(t -> t.accept(tabVisibilityVisitor)).toSet();
    }

    @Nonnull
    private ImmutableMap<EntityType, DBEntityLinkedEntityPrivacy> findPrivacyData(EntityDetails entity) {
        EntityId entityId = entity.getId();
        DBEntity dbEntity = entity.getDBEntity();
        ImmutableSet entityChildTypes = this._configService.getAllowedChildrenType(dbEntity.getType());
        if (CollectionUtil.isEmpty((Iterable)entityChildTypes)) {
            return ImmutableMap.of();
        }
        ImmutableList result = this._entityService.getEntityLinkedEntityPrivacies((Map)ImmutableMap.of((Object)entityId, (Object)dbEntity)).get((Object)entityId);
        return FluentIterable.from((Iterable)result).filter(Predicates.compose((Predicate)new NullIsFalsePredicate<Iterable<AuthorityModel>>(){

            protected boolean applySafe(Iterable<AuthorityModel> input) {
                return FluentIterable.from(input).anyMatch(AuthorityModel.IS_VISIBLE);
            }
        }, (Function)DBEntityLinkedEntityPrivacy.GET_AVAILABLE_AUTHORITIES)).filter(Predicates.compose((Predicate)Predicates.in((Collection)entityChildTypes), (Function)DBEntityLinkedEntityPrivacy.GET_ENTITY_TYPE)).uniqueIndex(DBEntityLinkedEntityPrivacy.GET_ENTITY_TYPE);
    }

    @Nonnull
    private ListMultimap<String, EntityComponentModel> getEntityComponents(EntityDetails entity) {
        ImmutableListMultimap positionMap = Multimaps.index((Iterable)entity.getComponents().values(), (Function)ComponentModel.POSITION);
        LinkedListMultimap result = LinkedListMultimap.create();
        result.putAll((Object)COMPONENT_POSITION_TOP, this.getComponentsSorted((ImmutableList<ComponentModel>)positionMap.get((Object)ComponentPosition.CENTER)));
        result.putAll((Object)COMPONENT_POSITION_LEFT, this.getComponentsSorted((ImmutableList<ComponentModel>)positionMap.get((Object)ComponentPosition.TOP_LEFT)));
        result.putAll((Object)COMPONENT_POSITION_LEFT, this.getComponentsSorted((ImmutableList<ComponentModel>)positionMap.get((Object)ComponentPosition.BOTTOM_LEFT)));
        result.putAll((Object)COMPONENT_POSITION_RIGHT, this.getComponentsSorted((ImmutableList<ComponentModel>)positionMap.get((Object)ComponentPosition.TOP_RIGHT)));
        result.putAll((Object)COMPONENT_POSITION_RIGHT, this.getComponentsSorted((ImmutableList<ComponentModel>)positionMap.get((Object)ComponentPosition.BOTTOM_RIGHT)));
        return result;
    }

    @Nonnull
    private ImmutableList<EntityComponentModel> getComponentsSorted(@Nullable ImmutableList<ComponentModel> components) {
        if (CollectionUtil.isEmpty(components)) {
            return ImmutableList.of();
        }
        Ordering ordering = Ordering.natural().onResultOf(Functions.compose((Function)ComponentPositionConfig.ORDER_FUNCTION, (Function)ComponentModel.POSITION_CONFIG));
        return components.stream().sorted(ordering).filter(c -> ComponentModel.IS_VISIBLE_PREDICATE.apply(c)).map(c -> {
            NameAndParam nameAndParam = c.getType().getNameAndParam();
            return new EntityComponentModel(nameAndParam.getName(), nameAndParam.getParam());
        }).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    @Nonnull
    private Optional<EntityTab> createTab(EntityDetails entity, de.justsoftware.onx.container.shared.model.EntityTab tab) {
        return (Optional)tab.accept((EntityTabVisitor)new EntityTabCreator(entity));
    }

    @Nonnull
    private ImmutableSet<Action> getPermissions(EntityDetails entity, AuthorizationContext authContext) {
        ImmutableSet activatedEntityTypes = this._configService.getOrderedActivatedEntityTypes();
        ImmutableSet linkableEntityTypes = this._entityService.filterAllowedChildEntityTypes((Set)activatedEntityTypes, (Set)ImmutableSet.of((Object)entity.getId()), (AuthorizationCheckContextWithUserId)authContext).get((Object)entity.getId());
        ImmutableSet.Builder availableActions = ImmutableSet.builder().add((Object)StaticAction.VIDEOLINK_CREATE).add((Object)StaticAction.ALBUM_CREATE).add((Object)StaticAction.DOCUMENT_CREATE).add((Object)StaticAction.SURVEY_CREATE).add((Object)StaticEntityAction.ENTITY_INVITE).add((Object)StaticEntityAction.ENTITY_MODIFY_TITLE).addAll(Iterables.transform((Iterable)linkableEntityTypes, Actions::entityCreate)).add((Object)StaticEntityAction.ENTITY_RECOMMEND_AS_TASK).add((Object)StaticEntityAction.ENTITY_RECOMMEND).add((Object)StaticEntityAction.ENTITY_SEND_NEWSLETTER).add((Object)StaticEntityAction.ENTITY_DELETE).add((Object)StaticEntityAction.ENTITY_SEND_FEEDBACK).add((Object)StaticEntityAction.ENTITY_VERSION_EDIT_DRAFT).add((Object)StaticEntityAction.ENTITY_VERSION_REVIEW).add((Object)StaticItemAction.UNLIKE_UNSUBSCRIBE);
        if (entity.getVersion() != null) {
            availableActions.add((Object)StaticEntityAction.ENTITY_ARCHIVE);
        }
        return authContext.may((ItemId)entity.getId(), availableActions.build());
    }

    @ParametersAreNonnullByDefault
    private final class EntityEditTabVisibilityVisitor
    implements EntityEditTab.Visitor<Boolean> {
        private final EntityType _entityType;
        private final Set<? extends Action> _permissions;
        private final ImmutableMap<EntityType, DBEntityLinkedEntityPrivacy> _privacy;

        private EntityEditTabVisibilityVisitor(EntityType entityType, Set<? extends Action> tabPermissions, ImmutableMap<EntityType, DBEntityLinkedEntityPrivacy> entityLinkedPrivacy) {
            this._entityType = entityType;
            this._permissions = tabPermissions;
            this._privacy = entityLinkedPrivacy;
        }

        @Override
        public Boolean visitBase() {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visitSettings() {
            return this._permissions.contains(Actions.entityModifyTab((TabNameForConfiguration)TabNameForConfiguration.SETTINGS));
        }

        @Override
        public Boolean visitMembers() {
            return this._permissions.contains(Actions.entityModifyTab((TabNameForConfiguration)TabNameForConfiguration.MEMBERS));
        }

        @Override
        public Boolean visitImage() {
            return this._permissions.contains(Actions.entityModifyTab((TabNameForConfiguration)TabNameForConfiguration.IMAGE)) && (ConnectEntityController.this._configService.logoActivated(this._entityType) || ConnectEntityController.this._configService.iconActivated(this._entityType));
        }

        @Override
        public Boolean visitPrivacy() {
            return this._permissions.contains(Actions.entityModifyTab((TabNameForConfiguration)TabNameForConfiguration.PRIVACY)) && (FluentIterable.from((Iterable)ConnectEntityController.this._configService.getAvailableInvitingRuleAuthNames(this._entityType)).append((Iterable)ConnectEntityController.this._configService.getAvailableNewsletterRuleAuthNames(this._entityType)).anyMatch(AuthorityModel.IS_VISIBLE) || !this._privacy.isEmpty());
        }
    }

    @ParametersAreNonnullByDefault
    private final class EntityTabCreator
    implements EntityTabVisitor<Optional<EntityTab>> {
        private final EntityDetails _entity;
        private final Map<ComponentType, OptionsItem> _optionsItemByComponentType;

        private EntityTabCreator(EntityDetails entity) {
            this._entity = entity;
            this._optionsItemByComponentType = Maps.uniqueIndex((Iterable)entity.getOptionsItems(), (Function)OptionsItem.TO_COMPONENT_TYPE);
        }

        public Optional<EntityTab> visitChildEntities(EntityType type) {
            DynamicComponentType componentType = DynamicComponentTypeCreator.CHILD_ENTITIES.create(type.name());
            OptionsItem optionsItem = this._optionsItemByComponentType.get(componentType);
            de.justsoftware.onx.container.shared.model.EntityTab tab = (de.justsoftware.onx.container.shared.model.EntityTab)DynamicEntityTabCreator.CHILD_ENTITIES.create(type.getName());
            IconType icon = ConnectEntityController.this._configService.icon(type);
            if (EntityDurationTimeOption.OFF.equals((Object)ConnectEntityController.this._configService.getDurationTimeOption(type))) {
                return this.getTab(tab, optionsItem, icon);
            }
            long futureCount = optionsItem.getCount(FilterTypeCountType.FUTURE);
            long pastCount = optionsItem.getCount(FilterTypeCountType.PAST);
            return Optional.of(new EntityTab(tab.getName(), futureCount, icon.name(), futureCount + pastCount > 0L));
        }

        public Optional<EntityTab> visitDashboard() {
            return Optional.of(new EntityTab(StaticEntityTab.DASHBOARD.getName(), null, IconType.TH_LARGE.name(), true));
        }

        public Optional<EntityTab> visitInformation() {
            return Optional.of(new EntityTab(StaticEntityTab.INFORMATION.getName(), null, IconType.INFO_SIGN.name(), true));
        }

        public Optional<EntityTab> visitMember() {
            int visibleMemberCount = this._entity.getVisibleMemberCount();
            return this.getTab((de.justsoftware.onx.container.shared.model.EntityTab)StaticEntityTab.MEMBER, visibleMemberCount, IconType.SMILE, visibleMemberCount > 0);
        }

        public Optional<EntityTab> visitPictures() {
            OptionsItem optionsItem = this._optionsItemByComponentType.get(StaticComponentType.ALBUMS);
            return this.getTab((de.justsoftware.onx.container.shared.model.EntityTab)StaticEntityTab.ALBUMS, optionsItem, IconType.PICTURE);
        }

        public Optional<EntityTab> visitVideos() {
            OptionsItem optionsItem = this._optionsItemByComponentType.get(StaticComponentType.VIDEOLINK);
            return this.getTab((de.justsoftware.onx.container.shared.model.EntityTab)StaticEntityTab.VIDEOS, optionsItem, IconType.FILM);
        }

        public Optional<EntityTab> visitHierarchy() {
            return Optional.of(new EntityTab(StaticEntityTab.HIERARCHY.getName(), null, IconType.LOCATION_ARROW.name(), true));
        }

        public Optional<EntityTab> visitSurveys() {
            OptionsItem optionsItem = this._optionsItemByComponentType.get(StaticComponentType.SURVEY);
            return this.getTab((de.justsoftware.onx.container.shared.model.EntityTab)StaticEntityTab.SURVEYS, optionsItem, IconType.BAR_CHART);
        }

        public Optional<EntityTab> visitDocuments() {
            OptionsItem optionsItem = this._optionsItemByComponentType.get(StaticComponentType.DOCUMENT);
            return this.getTab((de.justsoftware.onx.container.shared.model.EntityTab)StaticEntityTab.DOCUMENTS, optionsItem, IconType.PAPERCLIP, true);
        }

        @Nonnull
        private Optional<EntityTab> getTab(de.justsoftware.onx.container.shared.model.EntityTab tab, @Nullable OptionsItem optionsItem, IconType icon) {
            boolean hasTabData = optionsItem == null ? false : optionsItem.getCount(FilterTypeCountType.STANDARD) > 0;
            return this.getTab(tab, optionsItem, icon, hasTabData);
        }

        @Nonnull
        private Optional<EntityTab> getTab(de.justsoftware.onx.container.shared.model.EntityTab tab, @Nullable OptionsItem optionsItem, IconType icon, boolean hasTabData) {
            if (optionsItem == null) {
                return this.getTab(tab, 0L, icon, hasTabData);
            }
            long count = optionsItem.getCount(FilterTypeCountType.STANDARD);
            return this.getTab(tab, count, icon, hasTabData);
        }

        @Nonnull
        private Optional<EntityTab> getTab(de.justsoftware.onx.container.shared.model.EntityTab tab, long count, IconType icon, boolean hasTabData) {
            return Optional.of(new EntityTab(tab.getName(), count, icon.name(), hasTabData));
        }

        public Optional<EntityTab> visitSeparator() {
            return Optional.of(new EntityTab(StaticEntityTab.SEPARATOR.getName(), null, "", true));
        }

        public Optional<EntityTab> visitPrintPreview() {
            return Optional.of(new EntityTab(StaticEntityTab.PRINTPREVIEW.getName(), null, "PRINT", true));
        }

        public Optional<EntityTab> visitArchivedContent() {
            return Optional.of(new EntityTab(StaticEntityTab.ARCHIVEDCONTENT.getName(), null, "ARCHIVE", true));
        }
    }
}

