/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.content.impl;

import de.justsoftware.drive.content.SearchIndexUpdateService;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SearchIndexUpdateServiceImpl
implements SearchIndexUpdateService {
    private static final String SET = "set";
    private final SolrClient _solrClient;
    private final String _collection;

    @Autowired
    SearchIndexUpdateServiceImpl(SolrClient solrClient, @Value(value="${just.drive.solr.collection:common}") String collection) {
        this._solrClient = solrClient;
        this._collection = collection;
    }

    public void update(String documentId, String content) throws SolrServerException, IOException {
        SolrInputDocument solrDocument = new SolrInputDocument(new String[0]);
        solrDocument.setField("id", (Object)documentId);
        solrDocument.setField("type", Collections.singletonMap(SET, "DRIVE_DOCUMENT"));
        solrDocument.setField("just_app_id", Collections.singletonMap(SET, "DRIVE"));
        solrDocument.setField("content", Collections.singletonMap(SET, content));
        this._solrClient.add(this._collection, solrDocument);
    }

    public boolean isSolrAvailable() {
        try {
            this._solrClient.ping();
            return true;
        }
        catch (IOException | RuntimeException | SolrServerException e) {
            return false;
        }
    }
}

