/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.context.api.controller.support;

import de.justsoftware.onx.common.server.model.IdType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.design.shared.model.ThemeId;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import javax.annotation.Nonnull;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.InitBinder;

@ControllerAdvice(basePackages={"de.justsoftware.context.api.controller"})
public class JustContextApiIdCustomEditors {
    @InitBinder
    public void initBinder(@Nonnull WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(GlobalId.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) throws IllegalArgumentException {
                this.setValue(GlobalId.parse((String)text));
            }
        });
        dataBinder.registerCustomEditor(ThemeId.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (!text.startsWith(IdType.THEME_ID.getName() + IdType.THEME_ID.getDelimiter())) {
                    throw new IllegalArgumentException("Expected a theme ID, but instead got " + text);
                }
                Long id = GlobalId.parseId((String)text);
                if (id != null) {
                    this.setValue(new ThemeId(id.longValue()));
                }
            }
        });
        dataBinder.registerCustomEditor(TenantId.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                this.setValue(TenantId.parse((String)text).get());
            }
        });
    }
}

