/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.context.api.controller;

import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.security.jwt.JwtCookieManager;
import de.justsoftware.onx.tenant.business.TenantService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/context/api/v1/tenant"})
@ParametersAreNonnullByDefault
@Api(tags={"Tenant"})
public class TenantController {
    private final TenantService _tenantService;
    private final JwtCookieManager _jwtCookieManager;

    @Autowired
    public TenantController(TenantService tenantService, JwtCookieManager jwtCookieManager) {
        this._tenantService = tenantService;
        this._jwtCookieManager = jwtCookieManager;
    }

    @ApiOperation(value="Get current tenant id for the authorized user. The entityId parameter is ignored and only kept for backwards compatibility.", authorizations={@Authorization(value="oauth2")})
    @RequestMapping(method={RequestMethod.GET})
    @Deprecated
    @CheckForNull
    public TenantId getCurrentTenantId(@Nullable @RequestParam(name="rootEntityId", required=false) EntityId entityId, @AuthorizedContext AuthorizationContext authContext) {
        return authContext.getTenantId();
    }

    @ApiOperation(value="Switch tenant to given id", authorizations={@Authorization(value="oauth2")})
    @RequestMapping(method={RequestMethod.PUT}, path={"/change"})
    @CheckForNull
    public ResponseEntity<String> switchToTenant(@RequestParam TenantId tenantId, @AuthorizedContext AuthorizationContext authContext, HttpServletRequest request, HttpServletResponse response) {
        boolean switchedSuccessfully = this._tenantService.switchToTenant(authContext, tenantId);
        if (switchedSuccessfully) {
            this._jwtCookieManager.autoLoginNewTenant(request, response, SecurityContextHolder.getContext().getAuthentication());
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

