/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.context.api.controller;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.business.EntityTypeAppMappingService;
import de.justsoftware.onx.container.shared.model.EntityType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(path={"/context/api/v1/entityTypeAppMapping"})
@Api(tags={"EntityType To App Mappings"})
public class EntityTypeAppMappingController {
    private final EntityTypeAppMappingService _entityTypeAppMappingService;
    private final EntityConfigService _entityConfigService;

    @Autowired
    public EntityTypeAppMappingController(EntityTypeAppMappingService entityTypeAppMappingService, EntityConfigService entityConfigService) {
        this._entityTypeAppMappingService = entityTypeAppMappingService;
        this._entityConfigService = entityConfigService;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/mapping/{entityType}"})
    @ResponseBody
    @ApiOperation(value="Get configured mapping for given entity type.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - mapping returned"), @ApiResponse(code=500, message="entity type not known"), @ApiResponse(code=403, message="not authorized")})
    @Nonnull
    public AppId getEntityTypeAppMapping(@PathVariable(value="entityType") EntityType entityType, @AuthorizedContext AuthorizationContext authContext) {
        authContext.check((Action)StaticAction.ADMIN_SYSTEM_ADMINISTRATION);
        this.assertValidEntityType(entityType);
        return this._entityTypeAppMappingService.getAppForEntityType(entityType).getAppId();
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/mapping/{entityType}"})
    @ApiOperation(value="Set app mapping for given entity type.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - mapping returned"), @ApiResponse(code=500, message="entity type or appId not known"), @ApiResponse(code=403, message="not authorized")})
    public void setEntityTypeAppMapping(@PathVariable(value="entityType") EntityType entityType, @RequestBody AppId appId, @AuthorizedContext AuthorizationContext authContext) {
        authContext.check((Action)StaticAction.ADMIN_SYSTEM_ADMINISTRATION);
        this.assertValidEntityType(entityType);
        this._entityTypeAppMappingService.setAppForEntityType(entityType, appId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/{appId}"})
    @ResponseBody
    @ApiOperation(value="Get corresponding entity types for the given app.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - mapping returned"), @ApiResponse(code=500, message="appId not known"), @ApiResponse(code=403, message="not authorized")})
    @Nonnull
    public ImmutableSet<EntityType> getEntityTypesForApp(@PathVariable(value="appId") AppId appId) {
        return this._entityTypeAppMappingService.getEntityTypesForApp(this.getAppById(appId));
    }

    @Nonnull
    private CoreApp getAppById(@Nonnull AppId appId) {
        CoreApp coreApp = CoreApp.byAppId((AppId)appId);
        if (coreApp == null) {
            throw new IllegalStateException("Invalid app id " + appId);
        }
        return coreApp;
    }

    private void assertValidEntityType(EntityType entityType) {
        if (!this._entityConfigService.getOrderedActivatedEntityTypes().contains((Object)entityType)) {
            throw new IllegalArgumentException("Invalid entity type " + entityType);
        }
    }
}

