/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.context.api.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.context.api.business.HomeScreenService;
import de.justsoftware.context.api.business.JustContextService;
import de.justsoftware.context.api.model.JustContext;
import de.justsoftware.onx.appswitcher.business.AppConfigService;
import de.justsoftware.onx.appswitcher.model.UserAppConfig;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.common.business.configfile.ConfigService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.newszoom.business.NewsZoomSettingsService;
import de.justsoftware.onx.newszoom.business.model.NewsZoomSettingsBO;
import de.justsoftware.onx.person.business.PersonSettingService;
import de.justsoftware.onx.person.shared.model.ProductHintsOption;
import de.justsoftware.onx.server.business.JucoServerVersionService;
import de.justsoftware.onx.tenant.business.TenantService;
import de.justsoftware.onx.tenant.integration.persistence.model.Tenant;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class JustContextServiceImpl
implements JustContextService {
    private final Settings _settings;
    private final HomeScreenService _homeScreenService;
    private final AppConfigService _appConfigService;
    private final JucoServerVersionService _jucoServerVersionService;
    private final ConfigService _configService;
    private final PersonSettingService _personSettingService;
    private final NewsZoomSettingsService _newsZoomSettingsService;
    private final TenantService _tenantService;

    @Autowired
    public JustContextServiceImpl(Settings settings, HomeScreenService homeScreenService, AppConfigService appConfigService, JucoServerVersionService jucoServerVersionService, ConfigService configService, PersonSettingService personSettingService, NewsZoomSettingsService newsZoomSettingsService, TenantService tenantService) {
        this._settings = settings;
        this._homeScreenService = homeScreenService;
        this._jucoServerVersionService = jucoServerVersionService;
        this._configService = configService;
        this._appConfigService = appConfigService;
        this._personSettingService = personSettingService;
        this._newsZoomSettingsService = newsZoomSettingsService;
        this._tenantService = tenantService;
    }

    @Override
    public JustContext getContext(AuthorizationContext authContext) {
        PersonId userId = authContext.getUserId();
        Optional tenantId = authContext.getOptionalTenantId();
        String tenantName = tenantId.map(this::getTenantName).orElse(null);
        NewsZoomSettingsBO newsZoomSettings = this._newsZoomSettingsService.getNewsZoomSettings((AuthorizationCheckContextWithUserId)authContext);
        ImmutableList availableAppConfigs = this._appConfigService.getAvailableAppConfigs(authContext);
        Set<AppId> availableApps = availableAppConfigs.stream().map(UserAppConfig::getAppId).collect(Collectors.toSet());
        return new JustContext(authContext.getLocale(), userId, (ImmutableList<UserAppConfig>)availableAppConfigs, this._homeScreenService.getHomeScreenApps(authContext), this._jucoServerVersionService.getCurrentVersion(), tenantId.orElse(null), tenantName, newsZoomSettings, this.getFeatureToggles(availableApps), this._personSettingService.getPowerBarSetting(userId), this.getPollingIntervalInSeconds());
    }

    @CheckForNull
    private String getTenantName(TenantId tenantId) {
        return this._tenantService.getTenantById(tenantId).map(Tenant::getName).orElse(null);
    }

    private int getPollingIntervalInSeconds() {
        int pollingInterval = this._settings.getClientPollingInterval();
        int pollingRatio = this._settings.getWorkstreamReadPollRatio();
        return pollingInterval * pollingRatio;
    }

    @Nonnull
    private ImmutableMap<String, Boolean> getFeatureToggles(Set<AppId> availableApps) {
        boolean showProductHintsIcon = this._settings.getShowProductHints() == ProductHintsOption.SHOW_ICON;
        boolean chatOpticonEnabled = this._settings.isChatOpticonEnabled();
        return ImmutableMap.builder().put((Object)"showProductHintsIcon", (Object)showProductHintsIcon).put((Object)"isChatEnabled", (Object)(this._settings.isChatEnabled() && availableApps.contains(CoreApp.CONVERSATIONS.getAppId()) && !chatOpticonEnabled ? 1 : 0)).put((Object)"isBrowserPushServiceEnabled", (Object)this._settings.isBrowserPushServiceEnabled()).put((Object)"isChatOpticonEnabled", (Object)chatOpticonEnabled).build();
    }
}

