/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.context.api.business.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.justsoftware.context.api.business.HomeScreenService;
import de.justsoftware.onx.appswitcher.business.AppConfigService;
import de.justsoftware.onx.appswitcher.model.UserAppConfig;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.common.business.configfile.model.InitialVisibility;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.business.PersonSettingService;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class HomeScreenServiceImpl
implements HomeScreenService {
    private static final int MAX_HOME_SCREEN_PAGES = 10;
    private static final int MAX_APPS_ON_FIRST_PAGE = 8;
    private static final int MAX_APPS_ON_OTHER_PAGES = 12;
    private final PersonSettingService _personSettingsService;
    private final AppConfigService _appConfigService;

    @Autowired
    public HomeScreenServiceImpl(PersonSettingService personSettingsService, AppConfigService appConfigService) {
        this._personSettingsService = personSettingsService;
        this._appConfigService = appConfigService;
    }

    @Override
    public ImmutableList<ImmutableList<AppId>> getHomeScreenApps(AuthorizationContext authContext) {
        PersonId personId = authContext.getUserId();
        ImmutableList allAvailableApps = this._appConfigService.getAvailableAppConfigs(authContext);
        ImmutableList homeScreenApps = this._personSettingsService.getHomeScreenApps(personId);
        return this.createHomeScreenConfiguration((ImmutableList<ImmutableList<AppId>>)homeScreenApps, (ImmutableList<UserAppConfig>)allAvailableApps);
    }

    @Override
    public void setHomeScreenApps(AuthorizationContext authContext, ImmutableList<ImmutableList<AppId>> homeScreenApps) {
        ImmutableList allAvailableApps = this._appConfigService.getAvailableAppConfigs(authContext);
        ImmutableList<ImmutableList<AppId>> newHomeScreenAppConfiguration = this.createHomeScreenConfiguration(homeScreenApps, (ImmutableList<UserAppConfig>)allAvailableApps);
        this._personSettingsService.setHomeScreenApps(authContext.getUserId(), newHomeScreenAppConfiguration);
    }

    @Nonnull
    @VisibleForTesting
    ImmutableList<ImmutableList<AppId>> createHomeScreenConfiguration(ImmutableList<ImmutableList<AppId>> homeScreenApps, ImmutableList<UserAppConfig> availableApps) {
        boolean isEmpty = homeScreenApps.stream().allMatch(AbstractCollection::isEmpty);
        if (isEmpty) {
            return this.getDefaultApps(availableApps);
        }
        ImmutableList<ImmutableList<AppId>> availableHomeScreenApps = this.getAvailableHomeScreenApps(homeScreenApps, availableApps);
        ImmutableList<ImmutableList<AppId>> balancedHomeScreenPages = this.balanceHomeScreenPages(availableHomeScreenApps);
        ImmutableList<AppId> additionalForcedApps = this.getAdditionalForcedApps(balancedHomeScreenPages, availableApps);
        return ImmutableList.copyOf(this.mergeAdditionalForcedIntoHomeScreenApps(balancedHomeScreenPages, additionalForcedApps));
    }

    @Nonnull
    @VisibleForTesting
    ImmutableList<ImmutableList<AppId>> balanceHomeScreenPages(ImmutableList<ImmutableList<AppId>> homeScreenApps) {
        ArrayList remainingAppsToPlace = new ArrayList();
        ArrayList<ImmutableList> mergedHomeScreenApps = new ArrayList<ImmutableList>();
        for (int pageIndex = 0; pageIndex < homeScreenApps.size(); ++pageIndex) {
            boolean pageHasTooManyApps;
            ArrayList mutablePage = new ArrayList((Collection)homeScreenApps.get(pageIndex));
            int maxAppsOnPage = pageIndex == 0 ? 8 : 12;
            int numberOfRemainingAppsToPlace = remainingAppsToPlace.size();
            if (numberOfRemainingAppsToPlace > 0) {
                mutablePage.addAll(0, remainingAppsToPlace);
                remainingAppsToPlace.clear();
            }
            boolean bl = pageHasTooManyApps = mutablePage.size() > maxAppsOnPage;
            if (pageHasTooManyApps) {
                List overflowingApps = mutablePage.subList(maxAppsOnPage, mutablePage.size());
                remainingAppsToPlace.addAll(overflowingApps);
                mutablePage.removeAll(overflowingApps);
            }
            mergedHomeScreenApps.add(ImmutableList.copyOf(mutablePage));
        }
        return ImmutableList.copyOf(mergedHomeScreenApps);
    }

    @Nonnull
    @VisibleForTesting
    ImmutableList<ImmutableList<AppId>> mergeAdditionalForcedIntoHomeScreenApps(ImmutableList<ImmutableList<AppId>> homeScreenApps, ImmutableList<AppId> additionalForcedApps) {
        if (additionalForcedApps.isEmpty()) {
            return homeScreenApps;
        }
        ArrayList<AppId> remainingForcedAppsToAdd = new ArrayList<AppId>((Collection<AppId>)additionalForcedApps);
        ArrayList<ImmutableList> mergedHomeScreenApps = new ArrayList<ImmutableList>();
        for (int pageIndex = 0; pageIndex < homeScreenApps.size(); ++pageIndex) {
            ArrayList<Object> mutablePage = new ArrayList<Object>((Collection)homeScreenApps.get(pageIndex));
            int freeSlotsOnPage = pageIndex == 0 ? 8 - mutablePage.size() : 12 - mutablePage.size();
            int numberOfRemainingAppsToPlace = remainingForcedAppsToAdd.size();
            if (numberOfRemainingAppsToPlace > 0 && freeSlotsOnPage > 0) {
                if (numberOfRemainingAppsToPlace <= freeSlotsOnPage) {
                    mutablePage.addAll(remainingForcedAppsToAdd);
                    remainingForcedAppsToAdd.clear();
                } else {
                    List appsToPlace = remainingForcedAppsToAdd.subList(0, freeSlotsOnPage);
                    mutablePage.addAll(appsToPlace);
                    remainingForcedAppsToAdd.removeAll(appsToPlace);
                }
            }
            mergedHomeScreenApps.add(ImmutableList.copyOf(mutablePage));
        }
        return ImmutableList.copyOf(mergedHomeScreenApps);
    }

    @Nonnull
    @VisibleForTesting
    ImmutableList<ImmutableList<AppId>> getDefaultApps(ImmutableList<UserAppConfig> availableApps) {
        ImmutableList otherPages;
        ImmutableList firstPage;
        ImmutableList defaultApps = (ImmutableList)availableApps.stream().filter(availableApp -> availableApp.getInitialVisibility() != InitialVisibility.INVISIBLE).map(UserAppConfig::getAppId).collect(ImmutableList.toImmutableList());
        if (defaultApps.size() <= 8) {
            firstPage = defaultApps;
            otherPages = ImmutableList.of();
        } else {
            firstPage = defaultApps.subList(0, 8);
            ImmutableList remainingDefaultApps = defaultApps.subList(8, defaultApps.size());
            otherPages = (ImmutableList)Lists.partition((List)remainingDefaultApps, (int)12).stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
        }
        ImmutableList.Builder pagedDefaultAppsBuilder = ImmutableList.builder().add((Object)firstPage).addAll((Iterable)otherPages);
        int pagesToAdd = 9 - otherPages.size();
        for (int i = 0; i < pagesToAdd; ++i) {
            pagedDefaultAppsBuilder.add((Object)ImmutableList.of());
        }
        return pagedDefaultAppsBuilder.build();
    }

    @Nonnull
    @VisibleForTesting
    ImmutableList<ImmutableList<AppId>> getAvailableHomeScreenApps(ImmutableList<ImmutableList<AppId>> homeScreenApps, ImmutableList<UserAppConfig> availableApps) {
        ImmutableSet availableAppIds = (ImmutableSet)availableApps.stream().map(UserAppConfig::getAppId).collect(ImmutableSet.toImmutableSet());
        return (ImmutableList)homeScreenApps.stream().map(page -> (ImmutableList)page.stream().filter(arg_0 -> ((ImmutableSet)availableAppIds).contains(arg_0)).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    @VisibleForTesting
    ImmutableList<AppId> getAdditionalForcedApps(ImmutableList<ImmutableList<AppId>> homeScreenApps, ImmutableList<UserAppConfig> availableApps) {
        ImmutableSet validUserAppIdsSet = (ImmutableSet)homeScreenApps.stream().flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        return (ImmutableList)availableApps.stream().filter(availableApp -> availableApp.getInitialVisibility() == InitialVisibility.FORCED).map(UserAppConfig::getAppId).filter(((Predicate<AppId>)arg_0 -> ((ImmutableSet)validUserAppIdsSet).contains(arg_0)).negate()).collect(ImmutableList.toImmutableList());
    }
}

