/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.util;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class Strings {
    private Strings() {
    }

    @Nonnull
    public static String sentence(String text) {
        return text.isEmpty() ? text : text.substring(0, 1).toUpperCase() + text.substring(1);
    }

    @Nonnull
    public static String encodeBase64(String text) {
        return Base64.getUrlEncoder().encodeToString(text.getBytes(StandardCharsets.ISO_8859_1));
    }

    @Nonnull
    public static String decodeBase64(String text) {
        return new String(Base64.getUrlDecoder().decode(text), StandardCharsets.ISO_8859_1);
    }

    @Nonnull
    public static String removeSurrounding(String text, String delimiter) {
        if (text.length() >= 2 * delimiter.length() && text.startsWith(delimiter) && text.endsWith(delimiter)) {
            return text.substring(delimiter.length(), text.length() - delimiter.length());
        }
        return text;
    }
}

