/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.util;

import de.justsoftware.chat.api.model.Attachment;
import de.justsoftware.chat.api.model.Size;
import de.justsoftware.onx.chat.model.ChatAttachment;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class Sizes {
    private Sizes() {
    }

    @CheckForNull
    public static Size fromChatAttachment(ChatAttachment chatAttachment) {
        return Sizes.sizeOrNull(chatAttachment.getImageWidth(), chatAttachment.getImageHeight());
    }

    @CheckForNull
    public static Size fromAttachment(Attachment attachment) {
        return Sizes.sizeOrNull(attachment.getImageWidth(), attachment.getImageHeight());
    }

    @CheckForNull
    private static Size sizeOrNull(@Nullable Integer width, @Nullable Integer height) {
        return width != null && height != null ? new Size(width, height) : null;
    }
}

