/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.util;

import de.justsoftware.chat.api.model.Chat;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class Chats {
    private Chats() {
    }

    @Nonnull
    public static Set<String> ids(List<Chat> chats) {
        return chats.stream().map(Chat::getId).collect(Collectors.toSet());
    }

    @Nonnull
    public static Set<String> userIdsOfParticipants(List<Chat> chats) {
        return chats.stream().flatMap(chat -> chat.getParticipants().stream()).collect(Collectors.toSet());
    }

    @Nonnull
    public static Set<String> userGroupIds(List<Chat> chats) {
        return chats.stream().map(Chat::getUserGroups).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

