/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.util;

import de.justsoftware.chat.api.model.ChangeToken;
import de.justsoftware.chat.api.model.ChangeType;
import de.justsoftware.chat.api.service.ClientVersion;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Changes {
    public static boolean needsFullSync(ChangeType changeType, ChangeToken token, ClientVersion clientVersion) {
        return Changes.needsFullSyncAfterClientUpdate(changeType, token, clientVersion);
    }

    private static boolean needsFullSyncAfterClientUpdate(ChangeType changeType, ChangeToken token, ClientVersion clientVersion) {
        return Changes.clientSupportsChangeType(changeType, clientVersion) && Changes.clientOfLastSyncDidNotSupportChangeType(changeType, token, clientVersion.getPlatform());
    }

    private static boolean clientSupportsChangeType(ChangeType changeType, ClientVersion clientVersion) {
        long firstClientVersionSupportingChangeType;
        long currentClientVersion = clientVersion.getVersionCode();
        return currentClientVersion >= (firstClientVersionSupportingChangeType = Changes.firstClientVersionSupportingChangeType(changeType, clientVersion.getPlatform()));
    }

    private static boolean clientOfLastSyncDidNotSupportChangeType(ChangeType changeType, ChangeToken token, ClientVersion.Platform platform) {
        long clientVersionOfLastSync = token.getClientVersion();
        return clientVersionOfLastSync < Changes.firstClientVersionSupportingChangeType(changeType, platform);
    }

    private static long firstClientVersionSupportingChangeType(ChangeType changeType, ClientVersion.Platform platform) {
        switch (platform) {
            case ANDROID: {
                return changeType.getSinceAndroidAppVersion();
            }
            case IOS: {
                return changeType.getSinceIosAppVersion();
            }
        }
        return 0L;
    }
}

