/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.service.util;

import de.justsoftware.chat.api.model.ChatType;
import de.justsoftware.chat.api.model.MessageType;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.message.shared.model.ConversationType;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Types {
    @Nonnull
    public static MessageType messageType(ChatMessageType chatMessageType) {
        switch (chatMessageType) {
            case CHAT_MESSAGE: {
                return MessageType.TEXT;
            }
            case ADDED_TO_CONVERSATION: {
                return MessageType.ADDED_TO_CHAT;
            }
            case REMOVED_FROM_CONVERSATION: {
                return MessageType.REMOVED_FROM_CHAT;
            }
            case LEFT_CONVERSATION: {
                return MessageType.LEFT_CHAT;
            }
            case CONVERSATION_TITLE_CHANGED: {
                return MessageType.CHAT_TITLE_CHANGED;
            }
            case CONVERSATION_CREATED: {
                return MessageType.CHAT_CREATED;
            }
            case CONVERSATION_DELETED: {
                return MessageType.CHAT_DELETED;
            }
            case ATTACHMENT_CHAT_MESSAGE: {
                return MessageType.ATTACHMENT;
            }
            case PERSON_DELETED: {
                return MessageType.PERSON_DELETED;
            }
            case DELETED_CHAT_MESSAGE: {
                return MessageType.DELETED_MESSAGE;
            }
            case USER_GROUP_DELETED: {
                return MessageType.USER_GROUP_DELETED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown chat message type: %s", chatMessageType));
    }

    @Nonnull
    public static ChatType chatType(ConversationType conversationType) {
        return ChatType.valueOf(conversationType.name());
    }

    @Nonnull
    public static ConversationType conversationType(ChatType chatType) {
        return ConversationType.valueOf((String)chatType.name());
    }
}

