/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.service.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.chat.api.model.User;
import de.justsoftware.chat.api.service.ChatI18nService;
import de.justsoftware.chat.api.service.UserGroupMapper;
import de.justsoftware.chat.api.service.UserService;
import de.justsoftware.chat.api.service.util.ChatMessages;
import de.justsoftware.chat.api.service.util.Ids;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.chat.model.AffectedParticipantsChatMessage;
import de.justsoftware.onx.chat.model.AttachmentChatMessage;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.chat.model.ConversationCreatedChatMessage;
import de.justsoftware.onx.chat.model.ConversationTitleChangedChatMessage;
import de.justsoftware.onx.chat.model.SenderLeftChatMessage;
import de.justsoftware.onx.chat.model.TextChatMessage;
import de.justsoftware.onx.usergroup.business.impl.UserGroupService;
import de.justsoftware.onx.usergroup.model.UserGroup;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class MessageTranslator {
    private final AuthorizationContext _authCtx;
    private final ChatI18nService _i18nService;
    private final UserService _userService;
    private final UserGroupService _userGroupService;
    private final UserGroupMapper _userGroupMapper;

    public MessageTranslator(AuthorizationContext authCtx, ChatI18nService i18nService, UserService userService, UserGroupService userGroupService, UserGroupMapper userGroupMapper) {
        this._authCtx = authCtx;
        this._i18nService = i18nService;
        this._userService = userService;
        this._userGroupService = userGroupService;
        this._userGroupMapper = userGroupMapper;
    }

    @CheckForNull
    public String translate(ChatMessage message) {
        return ((Optional)message.getType().transform((ChatMessageType.Transformer)new MessageTransformer(this), (Object)message)).orElse(null);
    }

    @CheckForNull
    protected abstract String translateChatMessage(TextChatMessage var1);

    @CheckForNull
    protected abstract String translateAttachmentChatMessage(AttachmentChatMessage var1);

    @Nonnull
    protected String translateAddedToConversation(AffectedParticipantsChatMessage message) {
        return this.translateParticipantsModification(ChatI18nService.Modification.ADDED, message);
    }

    @Nonnull
    protected String translateRemovedFromConversation(AffectedParticipantsChatMessage message) {
        return this.translateParticipantsModification(ChatI18nService.Modification.REMOVED, message);
    }

    @Nonnull
    protected String translateLeftConversation(SenderLeftChatMessage message) {
        boolean stayingViaUserGroup = message.getSenderIsStayingInUserGroup();
        return ChatMessages.isSender((ChatMessage)message, this.currentUserId()) ? this._i18nService.youLeftTheChat(this.locale(), stayingViaUserGroup) : this._i18nService.oneLeftTheChat(this.locale(), this.userName(this._authCtx, (ChatMessage)message), stayingViaUserGroup);
    }

    @Nonnull
    protected String translateConversationTitleChanged(ConversationTitleChangedChatMessage message) {
        String oldTitle = message.getOldTitle();
        String newTitle = message.getNewTitle();
        return ChatMessages.isSender((ChatMessage)message, this.currentUserId()) ? this._i18nService.youChangedTitle(this.locale(), oldTitle, newTitle) : this._i18nService.someoneChangedTitle(this.locale(), this.userName(this._authCtx, (ChatMessage)message), oldTitle, newTitle);
    }

    @Nonnull
    protected String translateConversationCreated(ConversationCreatedChatMessage message) {
        String title = message.getTitle();
        if (title == null) {
            return ChatMessages.isSender((ChatMessage)message, this.currentUserId()) ? this._i18nService.youCreatedTheConversationWithoutTitle(this.locale()) : this._i18nService.someoneCreatedTheConversationWithoutTitle(this.locale(), this.userName(this._authCtx, (ChatMessage)message));
        }
        return ChatMessages.isSender((ChatMessage)message, this.currentUserId()) ? this._i18nService.youCreatedTheConversation(this.locale(), title) : this._i18nService.someoneCreatedTheConversation(this.locale(), this.userName(this._authCtx, (ChatMessage)message), title);
    }

    @Nonnull
    protected String translateConversationDeleted(ChatMessage message) {
        return this._i18nService.chatWasDeleted(this._authCtx.getLocale(), this.userName(this._authCtx, message));
    }

    @Nonnull
    protected String translatePersonDeleted() {
        return this._i18nService.deletedPersonWasRemovedFromChat(this.locale());
    }

    @Nonnull
    protected String translateUserGroupDeleted() {
        return this._i18nService.deletedUserGroupWasRemovedFromChat(this.locale());
    }

    @Nonnull
    protected String translateDeletedMessage(ChatMessage message) {
        return this._i18nService.deletedMessage(this.locale());
    }

    @Nonnull
    protected String translateParticipantsModification(ChatI18nService.Modification modified, AffectedParticipantsChatMessage message) {
        String currentUserId = this.currentUserId();
        boolean isCurrentUserAffected = this.isCurrentUserAffected(message, currentUserId);
        ImmutableSet<UserGroupId> teaserGroups = this.teaserGroupIds(message, isCurrentUserAffected);
        ImmutableSet<String> teaserUsers = this.teaserUserIds(message, teaserGroups.size(), isCurrentUserAffected);
        long teaserCount = teaserGroups.size() + teaserUsers.size();
        if (teaserCount == 0L) {
            throw new IllegalArgumentException(String.format("Unexpected number of affected participants: %s", message));
        }
        Set<String> userIdsStayingViaUserGroups = Ids.userIdsFromProfileIds(message.getRemovedPersonIdsStayingInUserGroups());
        boolean currentUserStaysViaUserGroups = isCurrentUserAffected && userIdsStayingViaUserGroups.contains(currentUserId);
        List<String> teaserNames = this.teaserNames((Set<UserGroupId>)teaserGroups, (Set<String>)teaserUsers);
        String author = this.authorName((ChatMessage)message);
        if (teaserCount == 1L) {
            boolean affectedUserStaysViaUserGroups = !teaserUsers.isEmpty() && userIdsStayingViaUserGroups.contains(teaserUsers.asList().get(0));
            return isCurrentUserAffected ? this._i18nService.youWere(modified, this.locale(), author, currentUserStaysViaUserGroups) : this._i18nService.oneWas(modified, this.locale(), teaserNames.get(0), author, affectedUserStaysViaUserGroups);
        }
        boolean otherUsersStayingViaUserGroups = currentUserStaysViaUserGroups ? userIdsStayingViaUserGroups.size() > 1 : userIdsStayingViaUserGroups.size() > 0;
        long additionalAffectedCount = message.getTotalAffectedCount() - teaserCount;
        if (additionalAffectedCount == 0L) {
            return this._i18nService.someWere(modified, this.locale(), teaserNames, author, currentUserStaysViaUserGroups, otherUsersStayingViaUserGroups);
        }
        return this._i18nService.someAndNAdditionalWere(modified, this.locale(), teaserNames, additionalAffectedCount, author, currentUserStaysViaUserGroups, otherUsersStayingViaUserGroups);
    }

    @Nonnull
    private ImmutableSet<UserGroupId> teaserGroupIds(AffectedParticipantsChatMessage message, boolean currentUserAffected) {
        int limit = currentUserAffected ? 4 : 5;
        return (ImmutableSet)message.getAllAffectedUserGroupIds().stream().limit(limit).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private ImmutableSet<String> teaserUserIds(AffectedParticipantsChatMessage message, int groupTeaserCount, boolean currentUserAffected) {
        int limit = 5 - groupTeaserCount;
        if (limit == 0) {
            return ImmutableSet.of();
        }
        Set<String> allAffectedUserIds = Ids.userIdsFromProfileIds(message.getAllAffectedPersonIds());
        return currentUserAffected ? this.withCurrentUserFirst(allAffectedUserIds, limit) : (ImmutableSet)allAffectedUserIds.stream().limit(limit).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private ImmutableSet<String> withCurrentUserFirst(Set<String> allAffectedUserIds, int limit) {
        String currentUserId = this.currentUserId();
        Stream<String> affectedUsersWithoutCurrentUser = allAffectedUserIds.stream().filter(id -> !Objects.equals(id, currentUserId)).limit(limit - 1);
        return (ImmutableSet)Stream.concat(Stream.of(currentUserId), affectedUsersWithoutCurrentUser).collect(ImmutableSet.toImmutableSet());
    }

    private boolean isCurrentUserAffected(AffectedParticipantsChatMessage message, String currentUserId) {
        Set<String> affectedParticipantUserIds = Ids.userIdsFromProfileIds(message.getAllAffectedPersonIds());
        return affectedParticipantUserIds.contains(currentUserId);
    }

    @Nonnull
    private List<String> teaserNames(Set<UserGroupId> groupIds, Set<String> userIds) {
        String currentUserId = this.currentUserId();
        List<UserGroup> groups = this.userGroups(groupIds);
        boolean currentUserAffected = userIds.contains(currentUserId);
        ImmutableSet userIdsWithoutCurrentUser = (ImmutableSet)userIds.stream().filter(userId -> !Objects.equals(userId, currentUserId)).collect(ImmutableSet.toImmutableSet());
        Stream<String> userNames = this._userService.users(this._authCtx, (Set<String>)userIdsWithoutCurrentUser).stream().map(user -> this._i18nService.userName(this.locale(), (User)user));
        Stream currentUserName = currentUserAffected ? Stream.of(this._i18nService.you(this.locale())) : Stream.empty();
        return Stream.of(currentUserName, this.userGroupNames(groups).stream(), userNames).flatMap(name -> name).collect(Collectors.toList());
    }

    @Nonnull
    private List<UserGroup> userGroups(Set<UserGroupId> userGroupIds) {
        ImmutableMap userGroupsByIds = this._userGroupService.getUserGroupsByIds(ImmutableSet.copyOf(userGroupIds));
        ImmutableSet missingUserGroupIds = Sets.difference(userGroupIds, (Set)userGroupsByIds.keySet()).immutableCopy();
        ArrayList<UserGroup> result = new ArrayList<UserGroup>((Collection<UserGroup>)userGroupsByIds.values());
        missingUserGroupIds.forEach(userGroupId -> result.add(this.deletedUserGroup((UserGroupId)userGroupId)));
        return result;
    }

    @Nonnull
    private UserGroup deletedUserGroup(UserGroupId userGroupId) {
        return new UserGroup(userGroupId, this._i18nService.deletedUserGroup(this.locale()), this._authCtx.getTenantId(), false);
    }

    @Nonnull
    private List<String> userGroupNames(List<UserGroup> userGroups) {
        return userGroups.stream().map(userGroup -> this._userGroupMapper.userGroupName(this.locale(), (UserGroup)userGroup)).collect(Collectors.toList());
    }

    @Nonnull
    protected String locale() {
        return this._authCtx.getLocale();
    }

    @Nonnull
    protected String currentUserId() {
        return Ids.userId(this._authCtx.getUserId());
    }

    @Nonnull
    private String authorName(ChatMessage message) {
        return ChatMessages.isSender(message, this.currentUserId()) ? this._i18nService.youDative(this._authCtx.getLocale()) : this.userName(this._authCtx, message);
    }

    @Nonnull
    private String userName(AuthorizationContext authCtx, ChatMessage message) {
        String userId = Ids.userId(message.getSentFrom());
        return this.userName(authCtx, userId);
    }

    @Nonnull
    protected String userName(AuthorizationContext authCtx, String userId) {
        User user = this._userService.user(authCtx, userId);
        return this._i18nService.userName(authCtx.getLocale(), user);
    }

    @ParametersAreNonnullByDefault
    private static class MessageTransformer
    implements ChatMessageType.Transformer<Optional<String>, ChatMessage> {
        private final MessageTranslator _translator;

        MessageTransformer(MessageTranslator translator) {
            this._translator = translator;
        }

        @Nonnull
        public Optional<String> transformChatMessage(ChatMessage message) {
            return this.translate(message, TextChatMessage.class, this._translator::translateChatMessage);
        }

        @Nonnull
        public Optional<String> transformAddedToConversation(ChatMessage message) {
            return this.translate(message, AffectedParticipantsChatMessage.class, this._translator::translateAddedToConversation);
        }

        @Nonnull
        public Optional<String> transformRemovedFromConversation(ChatMessage message) {
            return this.translate(message, AffectedParticipantsChatMessage.class, this._translator::translateRemovedFromConversation);
        }

        @Nonnull
        public Optional<String> transformLeftConversation(ChatMessage message) {
            return this.translate(message, SenderLeftChatMessage.class, this._translator::translateLeftConversation);
        }

        @Nonnull
        public Optional<String> transformConversationTitleChanged(ChatMessage message) {
            return this.translate(message, ConversationTitleChangedChatMessage.class, this._translator::translateConversationTitleChanged);
        }

        @Nonnull
        public Optional<String> transformConversationCreated(ChatMessage message) {
            return this.translate(message, ConversationCreatedChatMessage.class, this._translator::translateConversationCreated);
        }

        @Nonnull
        public Optional<String> transformConversationDeleted(ChatMessage message) {
            return this.translate(message, ChatMessage.class, this._translator::translateConversationDeleted);
        }

        @Nonnull
        public Optional<String> transformAttachmentChatMessage(ChatMessage message) {
            return this.translate(message, AttachmentChatMessage.class, this._translator::translateAttachmentChatMessage);
        }

        @Nonnull
        public Optional<String> transformPersonDeletedChatMessage(ChatMessage message) {
            return this.translate(message, ChatMessage.class, m -> this._translator.translatePersonDeleted());
        }

        @Nonnull
        public Optional<String> transformUserGroupDeletedChatMessage(ChatMessage message) {
            return this.translate(message, ChatMessage.class, m -> this._translator.translateUserGroupDeleted());
        }

        @Nonnull
        public Optional<String> transformDeletedChatMessage(ChatMessage message) {
            return this.translate(message, ChatMessage.class, this._translator::translateDeletedMessage);
        }

        @Nonnull
        private <T extends ChatMessage> Optional<String> translate(ChatMessage message, Class<T> expectedMessageClass, Function<T, String> translateMessage) {
            if (expectedMessageClass.isInstance(message)) {
                ChatMessage m = (ChatMessage)expectedMessageClass.cast(message);
                return Optional.ofNullable(translateMessage.apply(m));
            }
            throw new IllegalArgumentException(String.format("Expected message with type %s to be an instance of %s: %s", message.getType(), expectedMessageClass.getSimpleName(), message));
        }
    }
}

