/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.service.util;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Ids {
    @Nonnull
    public static String userId(ProfileId profileId) {
        return profileId.asString();
    }

    @Nonnull
    public static String userId(PersonId personId) {
        return Ids.userId(personId.asProfileId());
    }

    @Nonnull
    public static ProfileId profileId(String userId) {
        return ProfileId.parseNonnull((String)userId);
    }

    @Nonnull
    public static PersonId personId(String userId) {
        return Ids.profileId(userId).asPersonId();
    }

    @Nonnull
    public static Set<String> userIdsFromPersonIds(Set<PersonId> personIds) {
        return personIds.stream().map(Ids::userId).collect(Collectors.toSet());
    }

    @Nonnull
    public static Set<String> userIdsFromProfileIds(Set<ProfileId> profileIds) {
        return profileIds.stream().map(Ids::userId).collect(Collectors.toSet());
    }

    @Nonnull
    public static ImmutableSet<PersonId> personIds(Set<String> userIds) {
        return (ImmutableSet)userIds.stream().map(Ids::personId).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public static String messageId(ChatMessageId chatMessageId) {
        return chatMessageId.asString();
    }

    @Nonnull
    public static ChatMessageId chatMessageId(String messageId) {
        return ChatMessageId.parseNonnull((String)messageId);
    }

    @Nonnull
    public static String chatId(ConversationId conversationId) {
        return conversationId.asString();
    }

    @Nonnull
    public static ConversationId conversationId(String chatId) {
        return ConversationId.parseNonnull((String)chatId);
    }

    @Nonnull
    public static String userGroupIdToString(UserGroupId userGroupId) {
        return userGroupId.toString();
    }

    @Nonnull
    public static Set<String> userGroupIdsToString(Set<UserGroupId> userGroupIds) {
        return userGroupIds.stream().map(Ids::userGroupIdToString).collect(Collectors.toSet());
    }

    @Nonnull
    public static UserGroupId userGroupIdFromString(String userGroupId) {
        return UserGroupId.parseOrThrow((String)userGroupId);
    }

    @Nonnull
    public static ImmutableSet<UserGroupId> userGroupIdsFromString(Set<String> userGroupIds) {
        return (ImmutableSet)userGroupIds.stream().map(Ids::userGroupIdFromString).collect(ImmutableSet.toImmutableSet());
    }
}

