/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.service;

import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.chat.api.model.ImageId;
import de.justsoftware.chat.api.model.User;
import de.justsoftware.chat.api.model.exception.InternalServerException;
import de.justsoftware.chat.api.service.UserService;
import de.justsoftware.chat.api.service.util.Ids;
import de.justsoftware.chat.api.util.Users;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.ProfileReadRole;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.ValidatableException;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.profile.business.ProfileService;
import de.justsoftware.onx.searchnew.business.SearchService;
import de.justsoftware.onx.searchnew.shared.model.BlockSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ChatUserSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PersonSuggest;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.searchnew.shared.model.SuggestModel;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@ParametersAreNonnullByDefault
public class UserServiceImpl
implements UserService {
    private final PersonService _personService;
    private final ProfileService _profileService;
    private final SearchService _searchService;
    private final I18nService _i18nService;

    @Autowired
    public UserServiceImpl(PersonService personService, ProfileService profileService, SearchService searchService, I18nService i18nService) {
        this._personService = personService;
        this._profileService = profileService;
        this._searchService = searchService;
        this._i18nService = i18nService;
    }

    @Override
    public User user(AuthorizationContext authCtx, String id) {
        boolean allowedToSeeProfile = authCtx.may(ProfileReadRole.of((ProfileId)Ids.profileId(id)));
        return this.user(id, allowedToSeeProfile, authCtx.getLocale());
    }

    @Override
    @Nonnull
    public Set<User> users(AuthorizationContext authCtx, Set<String> ids) {
        ImmutableMap personsByIds = this._personService.getPersonsByIds(Ids.personIds(ids));
        Set allowedPersonIds = authCtx.filterRoles((ImmutableCollection)personsByIds.keySet().stream().map(ProfileReadRole::of).collect(ImmutableSet.toImmutableSet())).stream().map(ProfileId::asPersonId).collect(Collectors.toSet());
        ProfileConstants i18n = (ProfileConstants)this._i18nService.createProxy(ProfileConstants.class, authCtx.getLocale());
        return personsByIds.values().stream().map(person -> UserServiceImpl.toUser(person, allowedPersonIds.contains(person.getId()), i18n)).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public List<User> users(AuthorizationContext authCtx, String filter, int offset, int limit) {
        return this.suggestUsers(authCtx, filter, offset, limit).stream().filter(item -> item instanceof PersonSuggest).map(item -> (PersonSuggest)item).map(UserServiceImpl::toUser).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public User updateImage(AuthorizationContext authCtx, MultipartFile image) {
        try {
            this._profileService.saveProfileImage(authCtx.getUserId().asProfileId(), image, (AuthorizationCheckContext)authCtx);
            String userId = Ids.userId(authCtx.getUserId());
            return this.user(authCtx, userId);
        }
        catch (IOException e) {
            throw new InternalServerException("Error updating profile image", e);
        }
    }

    @Override
    @Nonnull
    public User deleteImage(AuthorizationContext authCtx) {
        try {
            this._profileService.deleteProfileImage(authCtx.getUserId().asProfileId(), (AuthorizationCheckContext)authCtx);
            String userId = Ids.userId(authCtx.getUserId());
            return this.user(authCtx, userId);
        }
        catch (ValidatableException | IOException e) {
            throw new InternalServerException("Error deleting profile image", e);
        }
    }

    @Nonnull
    private User user(String id, boolean allowedToSeeProfile, String locale) {
        PersonId personId = Ids.personId(id);
        DBPerson person = this._personService.getPersonByIdNotNull(personId);
        ProfileConstants i18n = (ProfileConstants)this._i18nService.createProxy(ProfileConstants.class, locale);
        return UserServiceImpl.toUser(person, allowedToSeeProfile, i18n);
    }

    @Nonnull
    private List<SuggestModel<?, ?>> suggestUsers(AuthorizationContext authCtx, String filter, int offset, int limit) {
        return this._searchService.suggest(filter, null, ImmutableSet.of((Object)StaticFilterType.PROFILES), SortType.ALPHABETICAL, (Collection)ImmutableSet.of((Object)BlockSubFilter.NON_BLOCKED, (Object)ChatUserSubFilter.CHAT_USER), offset, limit, (SearchAuthorizationCheckContext)authCtx).getResults();
    }

    @Nonnull
    private static User toUser(DBPerson person, boolean allowedToSeeProfile, ProfileConstants i18n) {
        String image = allowedToSeeProfile ? person.getImage() : null;
        String name = person.isDeleted() ? i18n.deletedUser() : person.getFullName();
        return new User(Ids.userId(person.getId()), name, new ImageId(ImageUrlUtil.imageOrDefault((String)image)), Users.userState(person.isActive(), person.isBlocked(), person.isDeleted()), allowedToSeeProfile, new DateTime((Object)person.getModifyDate()));
    }

    @Nonnull
    private static User toUser(PersonSuggest model) {
        Date modifyDate = (Date)Preconditions.checkNotNull((Object)model.getModifyDate(), (Object)"PersonSuggest.modifyDate == null");
        return new User(Ids.userId((PersonId)model.getId()), model.getName(), new ImageId(ImageUrlUtil.imageOrDefault((String)model.getLogo())), Users.userState(model.isActive(), model.isBlocked(), false), true, new DateTime((Object)modifyDate));
    }
}

