/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.service;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.chat.api.service.UserGroupMapper;
import de.justsoftware.chat.api.service.util.Ids;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.message.model.ChatUserGroupMode;
import de.justsoftware.onx.usergroup.model.UserGroup;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ChatRestApiUserGroupService")
@ParametersAreNonnullByDefault
public class UserGroupService {
    private final de.justsoftware.onx.usergroup.business.impl.UserGroupService _userGroupService;
    private final Settings _settings;
    private final UserGroupMapper _mapper;

    @Autowired
    public UserGroupService(de.justsoftware.onx.usergroup.business.impl.UserGroupService userGroupService, Settings settings, UserGroupMapper mapper) {
        this._userGroupService = userGroupService;
        this._settings = settings;
        this._mapper = mapper;
    }

    @Nonnull
    public List<de.justsoftware.chat.api.model.UserGroup> userGroups(AuthorizationContext authCtx, Set<String> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        Set userGroupIds = ids.stream().map(Ids::userGroupIdFromString).collect(Collectors.toSet());
        ImmutableMap userGroups = this._userGroupService.getUserGroupsByIds(ImmutableSet.copyOf(userGroupIds));
        Set readableUserGroupIds = this._userGroupService.filterUserGroupsWithRoleRead(userGroupIds, authCtx.getUserId());
        Set memberUserGroupIds = this._userGroupService.filterUserGroupsByMembership(userGroupIds, authCtx.getUserId());
        return userGroups.values().stream().map(userGroup -> this._mapper.toUserGroup(authCtx, (UserGroup)userGroup, readableUserGroupIds, memberUserGroupIds)).collect(Collectors.toList());
    }

    @Nonnull
    public Set<String> addAllUsersGroupIdIfApplicable(AuthorizationContext authCtx, Set<String> userGroupIds) {
        if (this._settings.getChatUserGroupMode() != ChatUserGroupMode.ALL_USER_GROUPS) {
            return userGroupIds;
        }
        String allUsersUserGroupId = this.getAllUsersUserGroupId(authCtx);
        if (allUsersUserGroupId == null || userGroupIds.contains(allUsersUserGroupId)) {
            return userGroupIds;
        }
        HashSet<String> userGroupIdsWithAllUsersGroup = new HashSet<String>(userGroupIds);
        userGroupIdsWithAllUsersGroup.add(allUsersUserGroupId);
        return userGroupIdsWithAllUsersGroup;
    }

    @CheckForNull
    private String getAllUsersUserGroupId(AuthorizationContext authCtx) {
        UserGroup allUsersGroup = this._userGroupService.getAllUsersGroup(authCtx.getTenantId());
        return allUsersGroup == null ? null : Ids.userGroupIdToString(allUsersGroup.getGroupId());
    }
}

