/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.service;

import de.justsoftware.chat.api.service.ChatI18nService;
import de.justsoftware.chat.api.service.util.Ids;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.usergroup.model.UserGroup;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ChatApiUserGroupMapper")
@ParametersAreNonnullByDefault
public class UserGroupMapper {
    private final ChatI18nService _chatI18nService;

    @Autowired
    public UserGroupMapper(ChatI18nService chatI18nService) {
        this._chatI18nService = chatI18nService;
    }

    @Nonnull
    public de.justsoftware.chat.api.model.UserGroup toUserGroup(AuthorizationContext authCtx, UserGroup userGroup, Set<UserGroupId> readableUserGroupIds, Set<UserGroupId> memberUserGroupIds) {
        return new de.justsoftware.chat.api.model.UserGroup(Ids.userGroupIdToString(userGroup.getGroupId()), this.userGroupName(authCtx.getLocale(), userGroup), userGroup.getIsAllTenantUsersGroup(), readableUserGroupIds.contains(userGroup.getGroupId()), memberUserGroupIds.contains(userGroup.getGroupId()), userGroup.getModifiedAt());
    }

    @Nonnull
    public String userGroupName(String locale, UserGroup userGroup) {
        return userGroup.getIsAllTenantUsersGroup() ? this._chatI18nService.allUsersGroup(locale) : userGroup.getName();
    }
}

