/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.service;

import com.freiheit.superoperty.Property;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.ImmutableList;
import de.justsoftware.chat.api.model.Setting;
import de.justsoftware.chat.api.service.SettingService;
import de.justsoftware.chat.api.service.TimeService;
import de.justsoftware.onx.message.model.ChatUserGroupMode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SettingServiceImpl
implements SettingService {
    private static final String ID_JUCO_VERSION = "JUCO_VERSION";
    private static final String ID_EDIT_PARTICIPANTS = "EDIT_PARTICIPANTS";
    private static final String ID_EDIT_TITLE = "EDIT_TITLE";
    private static final String ID_CHAT_SETTINGS = "CHAT_SETTINGS";
    private static final String ID_MUTE_CHAT = "MUTE_CHAT";
    private static final String ID_CHAT_MAX_PARTICIPANTS = "CHAT_MAX_PARTICIPANTS";
    private static final String ID_PREVIEW_VIDEOS = "PREVIEW_VIDEOS";
    private static final String ID_EDIT_PROFILE_IMAGE = "EDIT_PROFILE_IMAGE";
    private static final String ID_LOAD_ATTACHMENT_MESSAGES = "LOAD_ATTACHMENT_MESSAGES";
    private static final String ID_DELETE_MESSAGE = "DELETE_MESSAGE";
    private static final String ID_LOAD_SINGLE_USER = "LOAD_SINGLE_USER";
    private static final String ID_DELETE_CHAT = "DELETE_CHAT";
    private static final String ID_USER_GROUPS = "USER_GROUPS";
    private static final String ID_ALL_USERS_USER_GROUP = "ALL_USERS_USER_GROUP";
    private final InMemorySettings _settings;

    @Autowired
    public SettingServiceImpl(TimeService timeService, @Value(value="${justconnect.version}") String jucoVersion, Settings justSettings) {
        this._settings = new InMemorySettings(timeService).set(ID_JUCO_VERSION, jucoVersion).setEnabled(ID_EDIT_PARTICIPANTS).setEnabled(ID_EDIT_TITLE).setEnabled(ID_CHAT_SETTINGS).setEnabled(ID_MUTE_CHAT).set(ID_CHAT_MAX_PARTICIPANTS, justSettings.getMaxParticipantsInConversation()).setEnabled(ID_PREVIEW_VIDEOS).setEnabled(ID_EDIT_PROFILE_IMAGE).setEnabled(ID_LOAD_ATTACHMENT_MESSAGES).setEnabled(ID_DELETE_MESSAGE).setEnabled(ID_LOAD_SINGLE_USER).setEnabled(ID_DELETE_CHAT).set(ID_USER_GROUPS, justSettings.getChatUserGroupMode() != ChatUserGroupMode.NO_USER_GROUPS).set(ID_ALL_USERS_USER_GROUP, justSettings.getChatUserGroupMode() == ChatUserGroupMode.ALL_USER_GROUPS);
        this.doOnChange(justSettings.getMaxParticipantsInConversationProperty(), () -> this._settings.set(ID_CHAT_MAX_PARTICIPANTS, justSettings.getMaxParticipantsInConversation()));
        this.doOnChange(justSettings.getChatUserGroupModeProperty(), () -> {
            this._settings.set(ID_USER_GROUPS, justSettings.getChatUserGroupMode() != ChatUserGroupMode.NO_USER_GROUPS);
            this._settings.set(ID_ALL_USERS_USER_GROUP, justSettings.getChatUserGroupMode() == ChatUserGroupMode.ALL_USER_GROUPS);
        });
    }

    @Override
    @Nonnull
    public ImmutableList<Setting> settings() {
        return this._settings.toList();
    }

    @Override
    @Nonnull
    public ImmutableList<Setting> settings(DateTime since) {
        return this._settings.toFilteredList(setting -> since.isBefore((ReadableInstant)setting.getModifyDate()));
    }

    private void doOnChange(Property settingsProperty, Runnable action) {
        settingsProperty.addSuperopertyChangeListener(event -> action.run());
    }

    @ParametersAreNonnullByDefault
    private static class InMemorySettings {
        private final Map<String, Setting> _settings = new ConcurrentHashMap<String, Setting>(20);
        private final TimeService _timeService;

        InMemorySettings(TimeService timeService) {
            this._timeService = timeService;
        }

        @Nonnull
        ImmutableList<Setting> toList() {
            return ImmutableList.copyOf(this._settings.values());
        }

        @Nonnull
        ImmutableList<Setting> toFilteredList(Predicate<Setting> filter) {
            return (ImmutableList)this._settings.values().stream().filter(filter).collect(ImmutableList.toImmutableList());
        }

        @Nonnull
        InMemorySettings set(String id, String value) {
            this._settings.put(id, new Setting(id, value, this.modifyDate()));
            return this;
        }

        @Nonnull
        InMemorySettings set(String id, int value) {
            return this.set(id, String.valueOf(value));
        }

        @Nonnull
        InMemorySettings set(String id, boolean value) {
            return this.set(id, value ? "true" : "false");
        }

        @Nonnull
        InMemorySettings setEnabled(String id) {
            return this.set(id, true);
        }

        @Nonnull
        private DateTime modifyDate() {
            return this._timeService.now();
        }
    }
}

