/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.service;

import com.google.common.base.Functions;
import de.justsoftware.chat.api.model.PeopleApiSearchResult;
import de.justsoftware.chat.api.model.PeopleApiSearchResultRow;
import de.justsoftware.chat.api.model.SearchItemType;
import de.justsoftware.chat.api.model.SearchResult;
import de.justsoftware.chat.api.model.SearchResultItem;
import de.justsoftware.chat.api.model.User;
import de.justsoftware.chat.api.model.UserGroup;
import de.justsoftware.chat.api.model.UserGroupSearchResultItem;
import de.justsoftware.chat.api.model.UserSearchResultItem;
import de.justsoftware.chat.api.service.UserGroupService;
import de.justsoftware.chat.api.service.UserService;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SearchResultMapper {
    private final UserService _userService;
    private final UserGroupService _userGroupService;

    public SearchResultMapper(UserService userService, UserGroupService userGroupService) {
        this._userService = userService;
        this._userGroupService = userGroupService;
    }

    @Nonnull
    public SearchResult toSearchResult(PeopleApiSearchResult peopleSearchResult, AuthorizationContext authContext) {
        Map<String, User> users = this.users(peopleSearchResult, authContext);
        Map<String, UserGroup> userGroups = this.userGroups(peopleSearchResult, authContext);
        List<SearchResultItem<?>> searchResultItems = peopleSearchResult.getRows().stream().map(row -> this.toSearchResultItem((PeopleApiSearchResultRow)row, users, userGroups)).filter(Objects::nonNull).collect(Collectors.toList());
        return new SearchResult(searchResultItems);
    }

    @CheckForNull
    private SearchResultItem<?> toSearchResultItem(PeopleApiSearchResultRow row, Map<String, User> users, Map<String, UserGroup> userGroups) {
        SearchItemType itemType = SearchItemType.fromPeopleItemType(row.getType());
        if (itemType == null) {
            return null;
        }
        switch (itemType) {
            case USER: {
                User user = users.get(row.getId());
                return user != null ? new UserSearchResultItem(user) : null;
            }
            case USER_GROUP: {
                UserGroup userGroup = userGroups.get(row.getId());
                return userGroup != null ? new UserGroupSearchResultItem(userGroup) : null;
            }
        }
        return null;
    }

    @Nonnull
    private Map<String, User> users(PeopleApiSearchResult peopleSearchResult, AuthorizationContext authContext) {
        Set<String> userIds = this.ids(peopleSearchResult, SearchItemType.USER);
        return this._userService.users(authContext, userIds).stream().collect(Collectors.toUnmodifiableMap(User::getId, Functions.identity()));
    }

    @Nonnull
    private Map<String, UserGroup> userGroups(PeopleApiSearchResult peopleSearchResult, AuthorizationContext authContext) {
        Set<String> userGroupIds = this.ids(peopleSearchResult, SearchItemType.USER_GROUP);
        return this._userGroupService.userGroups(authContext, userGroupIds).stream().collect(Collectors.toUnmodifiableMap(UserGroup::getId, Functions.identity()));
    }

    @Nonnull
    private Set<String> ids(PeopleApiSearchResult peopleSearchResult, SearchItemType type) {
        return peopleSearchResult.getRows().stream().filter(row -> row.getType().equals(type.getPeopleItemType())).map(PeopleApiSearchResultRow::getId).collect(Collectors.toUnmodifiableSet());
    }
}

