/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.service;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.chat.api.model.PushPlatform;
import de.justsoftware.chat.api.service.PushService;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.push.business.PushNotificationReadWriteDataService;
import de.justsoftware.onx.push.shared.model.PushAppName;
import de.justsoftware.onx.push.shared.model.PushNotificationProtocol;
import de.justsoftware.onx.push.shared.model.PushRegistrationId;
import de.justsoftware.onx.push.shared.model.PushTargetApp;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PushServiceImpl
implements PushService {
    private final PushNotificationReadWriteDataService _dataService;

    @Autowired
    public PushServiceImpl(PushNotificationReadWriteDataService dataService) {
        this._dataService = dataService;
    }

    @Override
    public boolean register(AuthorizationContext authCtx, PushPlatform platform, String token) {
        PersonId personId = authCtx.getUserId();
        Optional<PushRegistrationId> existing = this.registration(personId, platform, token);
        if (existing.isPresent()) {
            return false;
        }
        this.addRegistration(personId, platform, token);
        return true;
    }

    @Override
    public boolean unregister(AuthorizationContext authCtx, PushPlatform platform, String token) {
        PersonId personId = authCtx.getUserId();
        Optional<PushRegistrationId> existing = this.registration(personId, platform, token);
        if (existing.isEmpty()) {
            return false;
        }
        this.removeRegistration(personId, existing.get());
        return true;
    }

    private void addRegistration(PersonId personId, PushPlatform platform, String token) {
        this._dataService.insertPushTargetApp(this.app(platform, token), personId);
    }

    private void removeRegistration(PersonId personId, PushRegistrationId id) {
        this._dataService.removePushTargetApp(id, personId);
    }

    @Nonnull
    private PushTargetApp app(PushPlatform platform, String token) {
        return new PushTargetApp(PushAppName.CHAT, token, this.protocol(platform));
    }

    @Nonnull
    private PushNotificationProtocol protocol(PushPlatform platform) {
        if (platform == PushPlatform.ANDROID) {
            return PushNotificationProtocol.FCM;
        }
        if (platform == PushPlatform.IOS) {
            return PushNotificationProtocol.APNS;
        }
        throw new IllegalArgumentException(String.format("Unsupported platform: %s", new Object[]{platform}));
    }

    @Nonnull
    private Optional<PushRegistrationId> registration(PersonId personId, PushPlatform platform, String token) {
        ImmutableMultimap appsByPersonId = this._dataService.getPushTargetAppsByPersonIds((Set)ImmutableSet.of((Object)personId));
        PushNotificationProtocol protocol = this.protocol(platform);
        if (!appsByPersonId.containsKey((Object)personId)) {
            return Optional.empty();
        }
        return appsByPersonId.get((Object)personId).stream().filter(app -> PushServiceImpl.appHandles(app, protocol, token)).map(PushTargetApp::getId).findFirst();
    }

    private static boolean appHandles(PushTargetApp app, PushNotificationProtocol protocol, String token) {
        return Objects.equals(app.getProtocol(), protocol) && Objects.equals(app.getToken(), token) && app.getId() != null;
    }
}

