/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.service;

import de.justsoftware.chat.api.model.ChatType;
import de.justsoftware.chat.api.service.ChatI18nService;
import de.justsoftware.chat.api.service.MessageTextService;
import de.justsoftware.chat.api.service.UserGroupMapper;
import de.justsoftware.chat.api.service.UserService;
import de.justsoftware.chat.api.service.util.Ids;
import de.justsoftware.chat.api.service.util.MessageTranslator;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.chat.model.AttachmentChatMessage;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.chat.model.TextChatMessage;
import de.justsoftware.onx.usergroup.business.impl.UserGroupService;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class MessageTextServiceImpl
implements MessageTextService {
    private final ChatI18nService _i18nService;
    private final UserService _userService;
    private final UserGroupService _userGroupService;
    private final UserGroupMapper _userGroupMapper;

    @Autowired
    public MessageTextServiceImpl(ChatI18nService i18nService, UserService userService, UserGroupService userGroupService, UserGroupMapper userGroupMapper) {
        this._i18nService = i18nService;
        this._userService = userService;
        this._userGroupService = userGroupService;
        this._userGroupMapper = userGroupMapper;
    }

    @Override
    public String messageText(AuthorizationContext authCtx, ChatMessage message) {
        MessageTextTranslator translator = new MessageTextTranslator(authCtx);
        return translator.translate(message);
    }

    @Override
    public String teaserText(AuthorizationContext authCtx, ChatMessage message, ChatType chatType) {
        MessageTeaserTranslator translator = new MessageTeaserTranslator(authCtx, chatType);
        return translator.translate(message);
    }

    @ParametersAreNonnullByDefault
    private class MessageTeaserTranslator
    extends MessageTranslator {
        private final AuthorizationContext _authCtx;
        private final ChatType _chatType;

        MessageTeaserTranslator(AuthorizationContext authCtx, ChatType chatType) {
            super(authCtx, MessageTextServiceImpl.this._i18nService, MessageTextServiceImpl.this._userService, MessageTextServiceImpl.this._userGroupService, MessageTextServiceImpl.this._userGroupMapper);
            this._authCtx = authCtx;
            this._chatType = chatType;
        }

        @Override
        protected String translateChatMessage(TextChatMessage message) {
            return this.withPrefix(Ids.userId(message.getSentFrom()), message.getMessage());
        }

        @Override
        protected String translateAttachmentChatMessage(AttachmentChatMessage message) {
            return this.withPrefix(Ids.userId(message.getSentFrom()), message.getAttachment().getFilename());
        }

        @Override
        protected String translateDeletedMessage(ChatMessage message) {
            return this.withPrefix(Ids.userId(message.getSentFrom()), super.translateDeletedMessage(message));
        }

        @Nonnull
        private String withPrefix(String senderId, String text) {
            if (senderId.equals(this.currentUserId())) {
                return MessageTextServiceImpl.this._i18nService.withPrefix(this.locale(), MessageTextServiceImpl.this._i18nService.me(this.locale()), text);
            }
            return this._chatType == ChatType.MULTI_USER_CHAT ? MessageTextServiceImpl.this._i18nService.withPrefix(this.locale(), this.userName(this._authCtx, senderId), text) : text;
        }
    }

    @ParametersAreNonnullByDefault
    private class MessageTextTranslator
    extends MessageTranslator {
        MessageTextTranslator(AuthorizationContext authCtx) {
            super(authCtx, MessageTextServiceImpl.this._i18nService, MessageTextServiceImpl.this._userService, MessageTextServiceImpl.this._userGroupService, MessageTextServiceImpl.this._userGroupMapper);
        }

        @Override
        protected String translateChatMessage(TextChatMessage message) {
            return message.getMessage();
        }

        @Override
        protected String translateAttachmentChatMessage(AttachmentChatMessage message) {
            return null;
        }
    }
}

