/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.service;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.chat.api.model.Attachment;
import de.justsoftware.chat.api.model.Change;
import de.justsoftware.chat.api.model.ChangeDeleteChat;
import de.justsoftware.chat.api.model.ChangeToken;
import de.justsoftware.chat.api.model.ChangeType;
import de.justsoftware.chat.api.model.ChangeUpdateChat;
import de.justsoftware.chat.api.model.ChangeUpdateChatSettings;
import de.justsoftware.chat.api.model.ChangeUpdateMessage;
import de.justsoftware.chat.api.model.ChangeUpdateSetting;
import de.justsoftware.chat.api.model.ChangeUpdateUser;
import de.justsoftware.chat.api.model.ChangeUpdateUserGroup;
import de.justsoftware.chat.api.model.Chat;
import de.justsoftware.chat.api.model.ChatSettings;
import de.justsoftware.chat.api.model.ChatType;
import de.justsoftware.chat.api.model.Message;
import de.justsoftware.chat.api.model.MessageType;
import de.justsoftware.chat.api.model.Setting;
import de.justsoftware.chat.api.model.User;
import de.justsoftware.chat.api.model.UserGroup;
import de.justsoftware.chat.api.model.exception.DeprecatedChangesException;
import de.justsoftware.chat.api.model.exception.IllegalTenantException;
import de.justsoftware.chat.api.model.exception.InvalidMessageException;
import de.justsoftware.chat.api.service.ChatMapper;
import de.justsoftware.chat.api.service.ChatService;
import de.justsoftware.chat.api.service.ClientVersion;
import de.justsoftware.chat.api.service.SettingService;
import de.justsoftware.chat.api.service.UserGroupService;
import de.justsoftware.chat.api.service.UserService;
import de.justsoftware.chat.api.service.util.Ids;
import de.justsoftware.chat.api.service.util.Types;
import de.justsoftware.chat.api.util.Changes;
import de.justsoftware.chat.api.util.ChatSettingsUtil;
import de.justsoftware.chat.api.util.Chats;
import de.justsoftware.chat.api.util.ImmutableCollections;
import de.justsoftware.chat.api.util.Messages;
import de.justsoftware.chat.api.util.Streams;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithUserId;
import de.justsoftware.onx.chat.integration.persistence.ChatAttachmentRepository;
import de.justsoftware.onx.chat.model.AttachmentFilter;
import de.justsoftware.onx.chat.model.ChatAttachment;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.common.server.model.HasMoreList;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.message.business.MessageService;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.model.ConversationSettings;
import de.justsoftware.onx.message.model.MessageLoadDirection;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import de.justsoftware.onx.message.shared.model.ConversationChangeType;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@ParametersAreNonnullByDefault
public class ChatServiceImpl
implements ChatService {
    private static final int MAX_CHATS_IN_CHANGES = 500;
    private static final int MAX_MESSAGES_IN_CHANGES = 2000;
    private final MessageService _messageService;
    private final UserService _userService;
    private final UserGroupService _userGroupService;
    private final SettingService _settingService;
    private final ChatAttachmentRepository _chatAttachmentRepository;
    private final Clock _clock;
    private final Settings _settings;
    private final ChatMapper _mapper;

    @Autowired
    public ChatServiceImpl(MessageService messageService, UserService userService, UserGroupService userGroupService, SettingService settingService, ChatAttachmentRepository chatAttachmentRepository, Clock clock, Settings settings, ChatMapper mapper) {
        this._messageService = messageService;
        this._userService = userService;
        this._userGroupService = userGroupService;
        this._settingService = settingService;
        this._chatAttachmentRepository = chatAttachmentRepository;
        this._clock = clock;
        this._settings = settings;
        this._mapper = mapper;
    }

    @Override
    @Nonnull
    public List<Chat> recentChats(AuthorizationContext authCtx, int offset, int limit) {
        ImmutableMap conversations = this._messageService.getRecentConversationsForLoggedInUser((AuthorizationCheckContextWithUserId)authCtx, offset, limit);
        return this._mapper.toChats(authCtx, (Map<ConversationId, Conversation>)conversations);
    }

    @Override
    @Nonnull
    public Chat chat(AuthorizationContext authCtx, String chatId) {
        return this.chatInternal(authCtx, chatId);
    }

    @Override
    @Nonnull
    public Chat startChat(AuthorizationContext authCtx, Chat chat) {
        Conversation conversation = this._messageService.getOrCreateConversation(Types.conversationType(chat.getType()), Ids.personIds(chat.getParticipants()), Ids.userGroupIdsFromString(chat.getUserGroups()), chat.getTitle(), this.toUUID(chat.getId()), (AuthorizationCheckContextWithUserId)authCtx);
        return this._mapper.toChat(authCtx, conversation);
    }

    @Override
    public void deleteChat(AuthorizationContext authCtx, String chatId) {
        this._messageService.deleteConversation(Ids.conversationId(chatId), (AuthorizationCheckContextWithUserId)authCtx);
    }

    @CheckForNull
    private UUID toUUID(@Nullable String id) {
        if (id == null) {
            return null;
        }
        try {
            return UUID.fromString(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    @Nonnull
    public Chat read(AuthorizationContext authCtx, String chatId, DateTime readTime) {
        this._messageService.markConversationAsRead((AuthorizationCheckContextWithUserId)authCtx, Ids.conversationId(chatId), readTime);
        return this.chatInternal(authCtx, chatId);
    }

    @Override
    @Nonnull
    public List<Message> messages(AuthorizationContext authCtx, String chatId, @Nullable String offsetMessageId, int limit) {
        HasMoreList messages = this._messageService.getMessagesByConversation(Ids.conversationId(chatId), this.offsetDateFromMessage(authCtx, offsetMessageId), limit, MessageLoadDirection.LOAD_OLDER_MESSAGES, (AuthorizationCheckContext)authCtx);
        return messages.getSubList().stream().map(chatMessage -> this._mapper.toMessage(authCtx, (ChatMessage)chatMessage)).collect(Collectors.toList());
    }

    @Override
    public List<Message> attachmentMessages(AuthorizationContext authCtx, String chatId, @Nullable AttachmentFilter filter, @Nullable String offsetMessageId, int limit) {
        HasMoreList messages = this._messageService.getConversationAttachments(Ids.conversationId(chatId), limit, this.offsetDateFromMessage(authCtx, offsetMessageId), filter, (AuthorizationCheckContextWithUserId)authCtx);
        return messages.getSubList().stream().map(chatMessage -> this._mapper.toMessage(authCtx, (ChatMessage)chatMessage)).collect(Collectors.toList());
    }

    @Override
    public Message message(AuthorizationContext authCtx, String messageId) {
        ChatMessage chatMessage = this._messageService.getMessageById(Ids.chatMessageId(messageId), (AuthorizationCheckContextWithUserId)authCtx);
        return this._mapper.toMessage(authCtx, chatMessage);
    }

    @Override
    @Nonnull
    public Message createMessage(AuthorizationContext authCtx, String chatId, @Nullable String messageId, MessageType messageType, String text, boolean markAsRead) {
        if (messageType != MessageType.TEXT) {
            throw new InvalidMessageException(String.format("Unable to create message of type %s", new Object[]{messageType}));
        }
        ChatMessage chatMessage = this._messageService.addTextChatMessage(Ids.conversationId(chatId), text, this.toUUID(messageId), markAsRead, (AuthorizationCheckContextWithUserId)authCtx);
        return this._mapper.toMessage(authCtx, chatMessage);
    }

    @Override
    @Nonnull
    public Message createMessage(AuthorizationContext authCtx, String chatId, @Nullable String messageId, MultipartFile file, boolean markAsRead) {
        ConversationId conversationId = Ids.conversationId(chatId);
        authCtx.check((ItemId)conversationId, (Action)StaticAction.CONVERSATION_READ);
        ChatAttachment attachment = this._chatAttachmentRepository.persist(conversationId, file, (AuthorizationCheckContextWithUserId)authCtx);
        try {
            ChatMessage chatMessage = this._messageService.addAttachmentChatMessage(conversationId, attachment, this.toUUID(messageId), markAsRead, (AuthorizationCheckContextWithUserId)authCtx);
            return this._mapper.toMessage(authCtx, chatMessage);
        }
        catch (RuntimeException e) {
            this._chatAttachmentRepository.rollbackByDocumentId(attachment.getDocumentId());
            throw e;
        }
    }

    @Override
    @Nonnull
    public Message deleteMessage(AuthorizationContext authCtx, String messageId) {
        ChatMessage deletedMessage = this._messageService.deleteMessage(Ids.chatMessageId(messageId), (AuthorizationCheckContextWithUserId)authCtx);
        return this._mapper.toMessage(authCtx, deletedMessage);
    }

    @Override
    @Nonnull
    public Attachment attachment(AuthorizationContext authCtx, String messageId) {
        return this.attachmentInternal(authCtx, messageId);
    }

    @Override
    @Nonnull
    public List<Change> changes(AuthorizationContext authCtx, @Nullable ChangeToken token, ClientVersion clientVersion) {
        DateTime since = ChangeToken.timestamp(token);
        this.checkChangesAreNotDeprecated(since);
        this.checkValidTenant(token, authCtx.getTenantId());
        ImmutableSet recentlyJoinedConversations = since != null ? this._messageService.getRecentlyJoinedConversations((AuthorizationContextWithUserId)authCtx, since) : ImmutableSet.of();
        List<Chat> updatedChats = this.updatedChats(authCtx, since);
        List<Message> updatedMessages = this.updatedMessages(authCtx, updatedChats, since);
        List<User> updatedUsers = this.updatedUsers(authCtx, updatedChats, (ImmutableSet<ConversationId>)recentlyJoinedConversations, updatedMessages, since);
        List<UserGroup> updatedUserGroups = this.updatedUserGroups(authCtx, updatedChats, (ImmutableSet<ConversationId>)recentlyJoinedConversations, token, clientVersion);
        List<ChangeDeleteChat> deletedChats = this.deletedChats(authCtx, since);
        List<Setting> updatedSettings = this.updatedSettings(token, clientVersion);
        List<ChatSettings> updatedChatSettings = this.updatedChatSettings(authCtx, updatedChats, token, clientVersion);
        return Streams.concat(updatedChats.stream().map(ChangeUpdateChat::new), updatedUsers.stream().map(ChangeUpdateUser::new), updatedUserGroups.stream().map(ChangeUpdateUserGroup::new), updatedMessages.stream().map(ChangeUpdateMessage::new), deletedChats.stream(), updatedSettings.stream().map(ChangeUpdateSetting::new), updatedChatSettings.stream().map(ChangeUpdateChatSettings::new)).sorted(Comparator.comparing(Change::getTimestamp)).collect(Collectors.toList());
    }

    @Override
    public Chat updateChat(AuthorizationContext authCtx, Chat chat) {
        Chat currentChat = this.chatInternal(authCtx, chat.getId());
        this.updateChatParticipants(authCtx, currentChat, chat);
        this.updateChatTitle(authCtx, currentChat, chat);
        return this.chatInternal(authCtx, chat.getId());
    }

    @Override
    public ChatSettings chatSettings(AuthorizationContext authCtx, String chatId) {
        return this._mapper.toChatSettings(this.conversationSettings(authCtx, chatId));
    }

    @Override
    @Nonnull
    public ChatSettings updateChatSettings(AuthorizationContext authCtx, ChatSettings chatSettings) {
        ConversationSettings existing = this.conversationSettings(authCtx, chatSettings.getChatId());
        if (!ChatSettingsUtil.needsUpdate(existing, chatSettings)) {
            return this._mapper.toChatSettings(existing);
        }
        ConversationSettings updated = ChatSettingsUtil.updateFromChatSettings(existing, chatSettings);
        this._messageService.setConversationSettings(updated, (AuthorizationCheckContextWithUserId)authCtx);
        return this._mapper.toChatSettings(this.conversationSettings(authCtx, chatSettings.getChatId()));
    }

    @Nonnull
    private List<Chat> updatedChats(AuthorizationContext authCtx, @Nullable DateTime since) {
        ImmutableMap conversations = since == null ? this._messageService.getRecentConversationsForLoggedInUser((AuthorizationCheckContextWithUserId)authCtx, 0, 500) : ImmutableCollections.merge(new Map[]{this._messageService.getUpdatedConversationsForLoggedInUser((AuthorizationCheckContextWithUserId)authCtx, since), this._messageService.getOneOnOneConversationsWithUpdatedUsersForLoggedInUser((AuthorizationContextWithUserId)authCtx, since)});
        return this._mapper.toChats(authCtx, (Map<ConversationId, Conversation>)conversations);
    }

    @Nonnull
    private List<Message> updatedMessages(AuthorizationContext authCtx, List<Chat> chats, @Nullable DateTime since) {
        return this._messageService.getUpdatedMessagesForLoggedInUser((AuthorizationCheckContextWithUserId)authCtx, ChatServiceImpl.conversationIds(chats), since, 2000).stream().map(chatMessage -> this._mapper.toMessage(authCtx, (ChatMessage)chatMessage)).collect(Collectors.toList());
    }

    @Nonnull
    private List<User> updatedUsers(AuthorizationContext authCtx, List<Chat> updatedChats, ImmutableSet<ConversationId> recentlyJoinedConversations, List<Message> updatedMessages, @Nullable DateTime since) {
        ImmutableSet updatedUserIds;
        if (since == null) {
            updatedUserIds = ImmutableSet.builder().add((Object)Ids.userId(authCtx.getUserId())).addAll(Chats.userIdsOfParticipants(updatedChats)).addAll(Messages.userIdsOfAuthors(updatedMessages)).build();
        } else {
            Sets.SetView indirectParticipantAuthorUserIds = Sets.difference(Messages.userIdsOfAuthors(updatedMessages), Chats.userIdsOfParticipants(updatedChats));
            Set<String> updatedPersonUserIds = Ids.userIdsFromPersonIds((Set<PersonId>)this._messageService.getUpdatedPersonsForLoggedInUser((AuthorizationContextWithUserId)authCtx, recentlyJoinedConversations, since));
            updatedUserIds = Sets.union((Set)indirectParticipantAuthorUserIds, updatedPersonUserIds).immutableCopy();
        }
        return ImmutableList.copyOf(this._userService.users(authCtx, (Set<String>)updatedUserIds));
    }

    @Nonnull
    private List<UserGroup> updatedUserGroups(AuthorizationContext authCtx, List<Chat> updatedChats, ImmutableSet<ConversationId> recentlyJoinedConversations, @Nullable ChangeToken token, ClientVersion currentVersion) {
        Set<String> userGroupIds = this.updatedUserGroupIds(authCtx, updatedChats, recentlyJoinedConversations, token, currentVersion);
        return this._userGroupService.userGroups(authCtx, userGroupIds);
    }

    @Nonnull
    private Set<String> updatedUserGroupIds(AuthorizationContext authCtx, List<Chat> updatedChats, ImmutableSet<ConversationId> recentlyJoinedConversations, @Nullable ChangeToken token, ClientVersion currentVersion) {
        if (token == null) {
            return this._userGroupService.addAllUsersGroupIdIfApplicable(authCtx, Chats.userGroupIds(updatedChats));
        }
        if (Changes.needsFullSync(ChangeType.USER_GROUP, token, currentVersion)) {
            List<Chat> updatedChatsFromFullSync = this.updatedChats(authCtx, null);
            return this._userGroupService.addAllUsersGroupIdIfApplicable(authCtx, Chats.userGroupIds(updatedChatsFromFullSync));
        }
        DateTime since = ChangeToken.timestamp(token);
        ImmutableSet ids = this._messageService.getUpdatedUserGroupsForLoggedInUser((AuthorizationContextWithUserId)authCtx, recentlyJoinedConversations, since);
        return Ids.userGroupIdsToString((Set<UserGroupId>)ids);
    }

    @Nonnull
    private List<ChangeDeleteChat> deletedChats(AuthorizationContext authCtx, @Nullable DateTime since) {
        if (since == null) {
            return Collections.emptyList();
        }
        return this._messageService.getRecentConversationChangesForLoggedInUser((AuthorizationCheckContextWithUserId)authCtx, since).stream().filter(change -> Objects.equals(change.getChangeType(), ConversationChangeType.LEFT)).map(change -> new ChangeDeleteChat(Ids.chatId(change.getConversationId()), change.getCreateDate())).collect(Collectors.toList());
    }

    @Nonnull
    private List<Setting> updatedSettings(@Nullable ChangeToken token, ClientVersion currentVersion) {
        return token == null || Changes.needsFullSync(ChangeType.SETTING, token, currentVersion) ? this._settingService.settings() : this._settingService.settings(token.getTimestamp());
    }

    @Nonnull
    private List<ChatSettings> updatedChatSettings(AuthorizationContext authCtx, List<Chat> updatedChats, @Nullable ChangeToken token, ClientVersion clientVersion) {
        return this.updatedConversationSettings(authCtx, updatedChats, token, clientVersion).stream().map(cs -> new ChatSettings(Ids.chatId(cs.getConversationId()), cs.isMuted(), cs.getModifyDate())).collect(Collectors.toList());
    }

    @Nonnull
    private ImmutableCollection<ConversationSettings> updatedConversationSettings(AuthorizationContext authCtx, List<Chat> updatedChats, @Nullable ChangeToken token, ClientVersion version) {
        if (token == null) {
            return this.conversationSettingsForChats(authCtx, updatedChats);
        }
        if (Changes.needsFullSync(ChangeType.CHAT_SETTINGS, token, version)) {
            List<Chat> updatedChatsFromFullSync = this.updatedChats(authCtx, null);
            return this.conversationSettingsForChats(authCtx, updatedChatsFromFullSync);
        }
        return this._messageService.getUpdatedConversationSettingsForLoggedInUser((AuthorizationContextWithUserId)authCtx, token.getTimestamp());
    }

    @Nonnull
    private ImmutableCollection<ConversationSettings> conversationSettingsForChats(AuthorizationContext authCtx, List<Chat> chats) {
        ImmutableSet updatedConversationIds = (ImmutableSet)chats.stream().map(chat -> Ids.conversationId(chat.getId())).collect(ImmutableSet.toImmutableSet());
        return this._messageService.getConversationsSettingsOrDefaults(updatedConversationIds, (AuthorizationCheckContextWithUserId)authCtx).values();
    }

    @Nonnull
    private Chat chatInternal(AuthorizationContext authCtx, String chatId) {
        ConversationId conversationId = Ids.conversationId(chatId);
        Conversation conversation = this._messageService.getConversationById(conversationId, (AuthorizationCheckContext)authCtx);
        return this._mapper.toChat(authCtx, conversation);
    }

    @Nonnull
    private Attachment attachmentInternal(AuthorizationContext authCtx, String messageId) {
        Attachment attachment = this.message(authCtx, messageId).getAttachment();
        if (attachment == null) {
            String msg = String.format("Tried to access attachment of message %s without attachment.", messageId);
            throw new InvalidIdServiceException(msg);
        }
        return attachment;
    }

    @Nonnull
    private ConversationSettings conversationSettings(AuthorizationContext authCtx, String chatId) {
        ConversationId conversationId = Ids.conversationId(chatId);
        return (ConversationSettings)this._messageService.getConversationsSettingsOrDefaults(ImmutableSet.of((Object)conversationId), (AuthorizationCheckContextWithUserId)authCtx).get((Object)conversationId);
    }

    private void updateChatParticipants(AuthorizationContext authCtx, Chat currentChat, Chat updatedChat) {
        boolean userGroupsChanged;
        boolean participantsChanged = !Objects.equals(currentChat.getParticipants(), updatedChat.getParticipants());
        boolean bl = userGroupsChanged = !Objects.equals(currentChat.getUserGroups(), updatedChat.getUserGroups());
        if (!participantsChanged && !userGroupsChanged) {
            return;
        }
        ConversationId conversationId = Ids.conversationId(updatedChat.getId());
        ImmutableSet<PersonId> personIds = Ids.personIds(updatedChat.getParticipants());
        ImmutableSet<UserGroupId> userGroupIds = Ids.userGroupIdsFromString(updatedChat.getUserGroups());
        this._messageService.updateConversationParticipants(conversationId, personIds, userGroupIds, null, (AuthorizationCheckContextWithUserId)authCtx);
    }

    private void updateChatTitle(AuthorizationContext authCtx, Chat currentChat, Chat updateChat) {
        boolean titleChanged;
        boolean titleUpdateAllowed = updateChat.getType() == ChatType.MULTI_USER_CHAT;
        boolean bl = titleChanged = !Objects.equals(currentChat.getTitle(), updateChat.getTitle());
        if (!titleUpdateAllowed || !titleChanged) {
            return;
        }
        ConversationId conversationId = Ids.conversationId(updateChat.getId());
        this._messageService.updateMultiUserConversationTitle((AuthorizationCheckContextWithUserId)authCtx, conversationId, updateChat.getTitle(), null);
    }

    @CheckForNull
    private DateTime offsetDateFromMessage(AuthorizationContext authCtx, @Nullable String messageId) {
        if (messageId == null) {
            return null;
        }
        ChatMessageId chatMessageId = Ids.chatMessageId(messageId);
        ChatMessage message = this._messageService.getMessageById(chatMessageId, (AuthorizationCheckContextWithUserId)authCtx);
        return message.getCreateDate();
    }

    private void checkChangesAreNotDeprecated(@Nullable DateTime since) {
        boolean changesDeprecated;
        int changesTTL = this._settings.getConversationChangesTTLSeconds();
        boolean bl = changesDeprecated = since != null && changesTTL > 0 && since.isBefore((ReadableInstant)this._clock.now().minusSeconds(changesTTL));
        if (changesDeprecated) {
            throw new DeprecatedChangesException();
        }
    }

    private void checkValidTenant(@Nullable ChangeToken token, TenantId requestTenantId) {
        if (token != null && !requestTenantId.equals((Object)token.getTenantId())) {
            throw new IllegalTenantException(token.getTenantId(), requestTenantId);
        }
    }

    @Nonnull
    private static ImmutableSet<ConversationId> conversationIds(List<Chat> chats) {
        return (ImmutableSet)chats.stream().map(chat -> Ids.conversationId(chat.getId())).collect(ImmutableSet.toImmutableSet());
    }
}

