/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.service;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.chat.api.model.Attachment;
import de.justsoftware.chat.api.model.Chat;
import de.justsoftware.chat.api.model.ChatSettings;
import de.justsoftware.chat.api.model.ChatType;
import de.justsoftware.chat.api.model.DriveDocumentId;
import de.justsoftware.chat.api.model.DriveDocumentVersionId;
import de.justsoftware.chat.api.model.Message;
import de.justsoftware.chat.api.model.User;
import de.justsoftware.chat.api.service.MessageTextService;
import de.justsoftware.chat.api.service.UserService;
import de.justsoftware.chat.api.service.util.Ids;
import de.justsoftware.chat.api.service.util.Types;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.chat.model.AttachmentChatMessage;
import de.justsoftware.onx.chat.model.ChatAttachment;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.message.business.MessageService;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.model.ConversationReadData;
import de.justsoftware.onx.message.model.ConversationSettings;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.message.util.Conversations;
import de.justsoftware.onx.thumbor.business.ThumborService;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ChatApiChatMapper")
@ParametersAreNonnullByDefault
public class ChatMapper {
    private final MessageService _messageService;
    private final MessageTextService _messageTextService;
    private final UserService _userService;
    private final ThumborService _thumborService;

    @Autowired
    public ChatMapper(MessageService messageService, MessageTextService messageTextService, UserService userService, ThumborService thumborService) {
        this._messageService = messageService;
        this._messageTextService = messageTextService;
        this._userService = userService;
        this._thumborService = thumborService;
    }

    @Nonnull
    public List<Chat> toChats(AuthorizationContext authCtx, Map<ConversationId, Conversation> conversations) {
        if (conversations.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableSet chatIds = ImmutableSet.copyOf(conversations.keySet());
        ImmutableMap unreadMessagesCounts = this._messageService.getUnreadMessagesCountForConversations((AuthorizationCheckContextWithUserId)authCtx, chatIds);
        ImmutableMap teaserMessages = this._messageService.getLatestChatMessage((ImmutableCollection)chatIds, (AuthorizationCheckContext)authCtx);
        return conversations.values().stream().filter(Objects::nonNull).map(arg_0 -> this.lambda$toChats$0(authCtx, (Map)unreadMessagesCounts, (Map)teaserMessages, arg_0)).collect(Collectors.toList());
    }

    @Nonnull
    public Message toMessage(AuthorizationContext authCtx, ChatMessage message) {
        Attachment attachment = this.toAttachment(message);
        String text = this._messageTextService.messageText(authCtx, message);
        return new Message(Ids.messageId(message.getId()), Types.messageType(message.getType()), Ids.chatId(message.getConversationId()), message.getCreateDate(), Ids.userId(message.getSentFrom()), text, attachment);
    }

    @CheckForNull
    public Attachment toAttachment(ChatMessage message) {
        if (message instanceof AttachmentChatMessage) {
            ChatAttachment attachment = ((AttachmentChatMessage)message).getAttachment();
            return new Attachment(new DriveDocumentId(attachment.getDocumentId()), new DriveDocumentVersionId(attachment.getDocumentVersionId()), attachment.getFilename(), attachment.getSize(), attachment.getContentType(), attachment.getImageWidth(), attachment.getImageHeight(), this.hasThumbnail(attachment));
        }
        return null;
    }

    @Nonnull
    public Chat toChat(AuthorizationContext authCtx, Conversation conversation) {
        ConversationId conversationId = conversation.getId();
        ConversationReadData conversationReadData = (ConversationReadData)this._messageService.getUnreadMessagesCountForConversations((AuthorizationCheckContextWithUserId)authCtx, ImmutableSet.of((Object)conversationId)).get((Object)conversationId);
        ChatMessage teaserMessage = (ChatMessage)this._messageService.getLatestChatMessage((ImmutableCollection)ImmutableSet.of((Object)conversationId), (AuthorizationCheckContext)authCtx).get((Object)conversationId);
        return this.toChat(authCtx, conversation, conversationReadData, teaserMessage);
    }

    @Nonnull
    public Chat toChat(AuthorizationContext authCtx, Conversation c, @Nullable ConversationReadData readData, @Nullable ChatMessage teaserMessage) {
        switch (c.getType()) {
            case MULTI_USER_CHAT: {
                return this.toMultiUserChat(authCtx, c, readData, teaserMessage);
            }
            case ONE_ON_ONE: {
                return this.toOneOnOneChat(authCtx, c, readData, teaserMessage);
            }
        }
        String msg = String.format("Conversation with unknown ConversationType: %s", c);
        throw new IllegalArgumentException(msg);
    }

    @Nonnull
    private Chat toMultiUserChat(AuthorizationContext authCtx, Conversation c, @Nullable ConversationReadData readData, @Nullable ChatMessage teaserMessage) {
        String customTitle = c.getCustomTitle();
        String title = customTitle != null ? customTitle : "";
        String teaserMessageText = teaserMessage != null ? this._messageTextService.teaserText(authCtx, teaserMessage, ChatType.MULTI_USER_CHAT) : null;
        return Chat.multiUser(Ids.chatId(c.getId()), title, Ids.userIdsFromPersonIds((Set<PersonId>)c.getParticipants()), Ids.userIdsFromPersonIds((Set<PersonId>)c.getDeletedParticipants()), Ids.userGroupIdsToString((Set<UserGroupId>)c.getUserGroups()), c.getLastMessageDate(), ChatMapper.unreadMessagesCount(readData), ChatMapper.readDate(readData), teaserMessageText);
    }

    @Nonnull
    private Chat toOneOnOneChat(AuthorizationContext authCtx, Conversation c, @Nullable ConversationReadData readData, @Nullable ChatMessage teaserMessage) {
        PersonId otherPersonId = Conversations.firstRecipientId((Conversation)c, (PersonId)authCtx.getUserId());
        if (otherPersonId == null) {
            String msg = String.format("OneOnOne chat without second participant: %s", c);
            throw new IllegalStateException(msg);
        }
        User other = this._userService.user(authCtx, Ids.userId(otherPersonId));
        String title = other.getName();
        String teaserMessageText = teaserMessage != null ? this._messageTextService.teaserText(authCtx, teaserMessage, ChatType.ONE_ON_ONE) : null;
        return Chat.oneOnOne(Ids.chatId(c.getId()), title, other.getImageId(), Ids.userIdsFromPersonIds((Set<PersonId>)c.getParticipants()), Ids.userIdsFromPersonIds((Set<PersonId>)c.getDeletedParticipants()), c.getLastMessageDate(), ChatMapper.unreadMessagesCount(readData), ChatMapper.readDate(readData), teaserMessageText);
    }

    @Nonnull
    public ChatSettings toChatSettings(ConversationSettings conversationSettings) {
        return new ChatSettings(Ids.chatId(conversationSettings.getConversationId()), conversationSettings.isMuted(), conversationSettings.getModifyDate());
    }

    private boolean hasThumbnail(ChatAttachment attachment) {
        String contentType = attachment.getContentType();
        return this._thumborService.thumbnailAvailable(contentType);
    }

    private static int unreadMessagesCount(@Nullable ConversationReadData readData) {
        return readData != null ? readData.getUnreadCount() : 0;
    }

    @CheckForNull
    private static DateTime readDate(@Nullable ConversationReadData readData) {
        return readData != null ? readData.getReadDate() : null;
    }

    private /* synthetic */ Chat lambda$toChats$0(AuthorizationContext authCtx, Map unreadMessagesCounts, Map teaserMessages, Conversation c) {
        return this.toChat(authCtx, c, (ConversationReadData)unreadMessagesCounts.get(c.getId()), (ChatMessage)teaserMessages.get(c.getId()));
    }
}

