/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.service;

import com.google.common.base.Joiner;
import de.justsoftware.chat.api.model.User;
import de.justsoftware.chat.api.service.ChatI18nService;
import de.justsoftware.chat.api.util.Strings;
import de.justsoftware.onx.chat.shared.i18n.ChatMessages;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.ServerLocalizedMessages;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ChatI18nServiceImpl
implements ChatI18nService {
    private final ConcurrentHashMap<String, ServerLocalizedMessages> _cache = new ConcurrentHashMap(2);
    private final I18nService _i18nService;

    @Autowired
    public ChatI18nServiceImpl(I18nService i18nService) {
        this._i18nService = i18nService;
    }

    @Override
    public String youCreatedTheConversation(String locale, String title) {
        return Strings.sentence(this.chatMessages(locale).youCreatedTheConversation(title));
    }

    @Override
    public String someoneCreatedTheConversation(String locale, String name, String title) {
        return Strings.sentence(this.chatMessages(locale).someoneCreatedTheConversation(name, title));
    }

    @Override
    public String youCreatedTheConversationWithoutTitle(String locale) {
        return Strings.sentence(this.chatMessages(locale).youCreatedTheConversationWithoutTitle());
    }

    @Override
    @Nonnull
    public String someoneCreatedTheConversationWithoutTitle(String locale, String name) {
        return Strings.sentence(this.chatMessages(locale).someoneCreatedTheConversationWithoutTitle(name));
    }

    @Override
    public String youChangedTitle(String locale, String oldTitle, String newTitle) {
        return Strings.sentence(this.chatMessages(locale).youChangedTitle(oldTitle, newTitle));
    }

    @Override
    public String someoneChangedTitle(String locale, String name, String oldTitle, String newTitle) {
        return Strings.sentence(this.chatMessages(locale).someoneChangedTitle(name, oldTitle, newTitle));
    }

    @Override
    public String youWere(ChatI18nService.Modification modified, String locale, String byWhom, boolean stayingViaUserGroups) {
        if (modified == ChatI18nService.Modification.ADDED) {
            return Strings.sentence(this.chatMessages(locale).youWereAddedBy(byWhom));
        }
        return stayingViaUserGroups ? Strings.sentence(this.chatMessages(locale).youWereRemovedButStayViaUserGroups(byWhom)) : Strings.sentence(this.chatMessages(locale).youWereRemovedBy(byWhom));
    }

    @Override
    public String oneWas(ChatI18nService.Modification modified, String locale, String who, String byWhom, boolean stayingViaUserGroups) {
        if (modified == ChatI18nService.Modification.ADDED) {
            return Strings.sentence(this.chatMessages(locale).oneWasAddedBy(who, byWhom));
        }
        return stayingViaUserGroups ? Strings.sentence(this.chatMessages(locale).oneWasRemovedByButStaysViaUserGroups(who, byWhom)) : Strings.sentence(this.chatMessages(locale).oneWasRemovedBy(who, byWhom));
    }

    @Override
    public String someWere(ChatI18nService.Modification modified, String locale, List<String> whos, String byWhom, boolean currentUserStaysViaUserGroups, boolean otherUsersStayingViaUserGroups) {
        if (modified == ChatI18nService.Modification.ADDED) {
            return Strings.sentence(this.chatMessages(locale).someWereAddedBy(this.join(locale, whos), byWhom));
        }
        if (currentUserStaysViaUserGroups) {
            return Strings.sentence(this.chatMessages(locale).someWereRemovedButCurrentUserStaysViaUserGroup(this.join(locale, whos), byWhom));
        }
        return otherUsersStayingViaUserGroups ? Strings.sentence(this.chatMessages(locale).someWereRemovedButSomeStayViaUserGroup(this.join(locale, whos), byWhom)) : Strings.sentence(this.chatMessages(locale).someWereRemovedBy(this.join(locale, whos), byWhom));
    }

    @Override
    public String someAndNAdditionalWere(ChatI18nService.Modification modified, String locale, List<String> whos, long more, String byWhom, boolean currentUserStaysViaUserGroups, boolean otherUsersStayingViaUserGroups) {
        if (modified == ChatI18nService.Modification.ADDED) {
            return Strings.sentence(this.chatMessages(locale).someAndNMoreWereAddedBy(this.join(locale, whos), Long.valueOf(more), byWhom));
        }
        if (currentUserStaysViaUserGroups) {
            return Strings.sentence(this.chatMessages(locale).someAndNMoreWereRemovedButCurrentUserStaysViaUserGroups(this.join(locale, whos), Long.valueOf(more), byWhom));
        }
        return otherUsersStayingViaUserGroups ? Strings.sentence(this.chatMessages(locale).someAndNMoreWereRemovedButSomeStayViaUserGroup(this.join(locale, whos), Long.valueOf(more), byWhom)) : Strings.sentence(this.chatMessages(locale).someAndNMoreWereRemovedBy(this.join(locale, whos), Long.valueOf(more), byWhom));
    }

    @Override
    public String chatWasDeleted(String locale, String byWhom) {
        return Strings.sentence(this.chatMessages(locale).chatWasDeleted(byWhom));
    }

    @Override
    public String oneLeftTheChat(String locale, String who, boolean stayingViaUserGroup) {
        return Strings.sentence(stayingViaUserGroup ? this.chatMessages(locale).oneLeftTheChatButStaysViaUserGroup(who) : this.chatMessages(locale).oneLeftTheChat(who));
    }

    @Override
    public String youLeftTheChat(String locale, boolean stayingViaUserGroup) {
        return Strings.sentence(stayingViaUserGroup ? this.chatMessages(locale).youLeftTheChatButStayViaUserGroup() : this.chatMessages(locale).youLeftTheChat());
    }

    @Override
    public String withPrefix(String locale, String prefix, String text) {
        return Strings.sentence(this.chatMessages(locale).withPrefix(prefix, text));
    }

    @Override
    public String and(String locale) {
        return this.chatMessages(locale).and();
    }

    @Override
    public String youDative(String locale) {
        return this.chatMessages(locale).youDative();
    }

    @Nonnull
    private String deletedUser(String locale) {
        return this.chatMessages(locale).deletedUser();
    }

    @Nonnull
    private String deactivatedUser(String locale, String userName) {
        return this.chatMessages(locale).deactivatedUser(userName);
    }

    @Nonnull
    private String blockedUser(String locale, String userName) {
        return this.chatMessages(locale).blockedUser(userName);
    }

    @Nonnull
    private String deactivatedAndBlockedUser(String locale, String userName) {
        return this.chatMessages(locale).deactivatedAndBlockedUser(userName);
    }

    @Override
    public String userName(String locale, User user) {
        switch (user.getState()) {
            case ACTIVE: {
                return user.getName();
            }
            case BLOCKED: {
                return this.blockedUser(locale, user.getName());
            }
            case DEACTIVATED: {
                return this.deactivatedUser(locale, user.getName());
            }
            case DEACTIVATED_BLOCKED: {
                return this.deactivatedAndBlockedUser(locale, user.getName());
            }
            case DELETED: {
                return this.deletedUser(locale);
            }
        }
        throw new IllegalStateException(String.format("Unknown user state of user: %s", user));
    }

    @Override
    public String you(String locale) {
        return this.chatMessages(locale).you();
    }

    @Override
    public String me(String locale) {
        return this.chatMessages(locale).me();
    }

    @Override
    public String deletedPersonWasRemovedFromChat(String locale) {
        return this.chatMessages(locale).deletedPersonWasRemovedFromChat();
    }

    @Override
    public String deletedUserGroupWasRemovedFromChat(String locale) {
        return this.chatMessages(locale).deletedUserGroupWasRemovedFromChat();
    }

    @Override
    public String deletedMessage(String locale) {
        return this.chatMessages(locale).deletedMessage();
    }

    @Override
    public String allUsersGroup(String locale) {
        return this.chatMessages(locale).allUsersUserGroupName();
    }

    @Override
    public String deletedUserGroup(String locale) {
        return this.chatMessages(locale).deletedUserGroup();
    }

    @Nonnull
    private ChatMessages chatMessages(String locale) {
        return this._cache.computeIfAbsent(locale, arg_0 -> ((I18nService)this._i18nService).getLocalizedMessages(arg_0)).chatMessages();
    }

    @Nonnull
    private String join(String locale, List<String> elements) {
        if (elements.isEmpty()) {
            return "";
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        int last = elements.size() - 1;
        List<String> allButLast = elements.subList(0, last);
        return String.format("%s %s %s", Joiner.on((String)", ").join(allButLast), this.and(locale), elements.get(last));
    }
}

