/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.service;

import de.justsoftware.chat.api.model.Attachment;
import de.justsoftware.chat.api.model.PeopleApiSearchResult;
import de.justsoftware.chat.api.model.SearchItemType;
import de.justsoftware.chat.api.model.ThumbnailSize;
import de.justsoftware.chat.api.model.exception.ApiGatewayException;
import de.justsoftware.chat.api.model.exception.IllegalAttachmentException;
import de.justsoftware.chat.api.service.ApiGatewayService;
import de.justsoftware.chat.api.util.Attachments;
import de.justsoftware.chat.api.util.Strings;
import de.justsoftware.onx.container.shared.model.TenantId;
import java.net.URI;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@ParametersAreNonnullByDefault
public class ApiGatewayServiceImpl
implements ApiGatewayService {
    private final String _driveApiUrl;
    private final String _peopleApiUrl;
    private final RestOperations _apiGatewayRestOperations;

    @Autowired
    public ApiGatewayServiceImpl(@Value(value="${just-drive.api.url}") String driveApiUrl, @Value(value="${just-people.api.url}") String peopleApiUrl, @Qualifier(value="apiGatewayRestOperations") RestOperations apiGatewayRestOperations) {
        this._driveApiUrl = driveApiUrl;
        this._peopleApiUrl = peopleApiUrl;
        this._apiGatewayRestOperations = apiGatewayRestOperations;
    }

    @Override
    @Nonnull
    public ResponseEntity<Resource> thumbnailImage(Attachment attachment, ThumbnailSize size) {
        if (!attachment.hasThumbnail()) {
            throw new IllegalAttachmentException(String.format("No thumbnail image available for attachment: %s", attachment));
        }
        return this.sendGetResource(this.thumbnailImageUrl(attachment, size));
    }

    @Override
    @Nonnull
    public ResponseEntity<Resource> previewImage(Attachment attachment) {
        return this.sendGetResource(this.previewImageUrl(attachment));
    }

    @Override
    @Nonnull
    public ResponseEntity<Resource> videoStream(Attachment attachment) {
        if (!Attachments.isVideo(attachment)) {
            throw new IllegalAttachmentException(String.format("No video stream available for attachment with content type: %s", attachment.getContentType()));
        }
        return this.sendGetResource(this.videoStreamUrl(attachment));
    }

    @Override
    @Nonnull
    public ResponseEntity<Resource> download(Attachment attachment) {
        return this.sendGetResource(this.downloadUrl(attachment));
    }

    @Override
    @Nonnull
    public String unauthorizedVideoStreamUrl(Attachment attachment) {
        if (!Attachments.isVideo(attachment)) {
            throw new IllegalAttachmentException(String.format("No video stream URL available for attachment with content type: %s", attachment.getContentType()));
        }
        String accessToken = this.sendGetString(this.videoStreamAccessToken(attachment));
        return this.unauthorizedVideoStreamUrl(accessToken);
    }

    @Override
    @Nonnull
    public PeopleApiSearchResult peopleSearchByName(TenantId tenantId, @Nullable String query, int offset, int limit, @Nullable List<SearchItemType> types) {
        URI uri = this.peopleSearchForNamesUri(tenantId, query, offset, limit, types);
        return this.sendGetObject(uri, PeopleApiSearchResult.class);
    }

    @Nonnull
    private String thumbnailImageUrl(Attachment attachment, ThumbnailSize size) {
        return String.format("%s/previews/thumbnail/%s?width=%s&height=%s", this._driveApiUrl, attachment.getDocumentId().getId(), size.getWidth(), size.getHeight());
    }

    @Nonnull
    private String previewImageUrl(Attachment attachment) {
        return String.format("%s/previews/previewImage/%s", this._driveApiUrl, attachment.getDocumentVersionId().getId());
    }

    @Nonnull
    private String videoStreamUrl(Attachment attachment) {
        return String.format("%s/previews/embed/%s", this._driveApiUrl, attachment.getDocumentVersionId().getId());
    }

    @Nonnull
    private String downloadUrl(Attachment attachment) {
        return String.format("%s/documents/fileversion/%s/download", this._driveApiUrl, attachment.getDocumentVersionId().getId());
    }

    @Nonnull
    private String videoStreamAccessToken(Attachment attachment) {
        return String.format("%s/previews/preview/%s/accessToken", this._driveApiUrl, attachment.getDocumentId().getId());
    }

    @Nonnull
    private String unauthorizedVideoStreamUrl(String accessToken) {
        return String.format("/drive/api/unauthenticated/previewVideoFile/%s", accessToken);
    }

    @Nonnull
    private URI peopleSearchForNamesUri(TenantId tenantId, @Nullable String query, int offset, int limit, @Nullable List<SearchItemType> types) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this._peopleApiUrl + "/search/names"));
        uriBuilder.queryParam("tenantId", new Object[]{tenantId.asString()});
        uriBuilder.queryParam("offset", new Object[]{offset});
        uriBuilder.queryParam("limit", new Object[]{limit});
        if (query != null) {
            uriBuilder.queryParam("query", new Object[]{query});
        }
        if (types != null) {
            List peopleTypes = types.stream().map(SearchItemType::getPeopleItemType).collect(Collectors.toList());
            uriBuilder.queryParam("type", peopleTypes);
        }
        return uriBuilder.build().toUri();
    }

    @Nonnull
    private ResponseEntity<Resource> sendGetResource(String url) {
        return ApiGatewayServiceImpl.wrapHttpErrors(() -> this._apiGatewayRestOperations.getForEntity(url, Resource.class, new Object[0]));
    }

    @Nonnull
    private String sendGetString(String url) {
        String response = ApiGatewayServiceImpl.wrapHttpErrors(() -> (String)this._apiGatewayRestOperations.getForObject(url, String.class, new Object[0]));
        return Strings.removeSurrounding(response, "\"");
    }

    @Nonnull
    private <T> T sendGetObject(URI uri, Class<T> resultType) {
        return (T)ApiGatewayServiceImpl.wrapHttpErrors(() -> this._apiGatewayRestOperations.getForObject(uri, resultType));
    }

    @Nonnull
    private static <R> R wrapHttpErrors(Supplier<R> apiCall) {
        try {
            R result = apiCall.get();
            if (result == null) {
                throw new ApiGatewayException("Received no response value from request", HttpStatus.NOT_FOUND);
            }
            return result;
        }
        catch (HttpStatusCodeException e) {
            throw new ApiGatewayException(e);
        }
    }
}

