/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.model;

import javax.annotation.Nonnull;

public enum ThumbnailSize {
    PREVIEW(30, 17),
    SMALL(200, 112),
    MEDIUM(300, 168),
    LARGE(400, 224);

    private final int _width;
    private final int _height;

    private ThumbnailSize(int width, int height) {
        this._width = width;
        this._height = height;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    @Nonnull
    public static ThumbnailSize of(@Nonnull String size) {
        String normalizedSize = size.trim().toUpperCase();
        try {
            return ThumbnailSize.valueOf(normalizedSize);
        }
        catch (IllegalArgumentException e) {
            return MEDIUM;
        }
    }
}

