/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.model;

import de.justsoftware.chat.api.model.exception.InvalidPushPlatformException;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public enum PushPlatform {
    ANDROID,
    IOS;


    @Nonnull
    public static PushPlatform parse(@Nullable String text) {
        if (!StringUtils.isBlank((String)text)) {
            try {
                return PushPlatform.valueOf(text.trim().toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw new InvalidPushPlatformException(String.format("Can't parse platform: %s", text));
    }
}

