/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.chat.api.model.ChatType;
import de.justsoftware.chat.api.model.ImageId;
import de.justsoftware.chat.api.util.Dates;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class Chat {
    private final String _id;
    private final ChatType _type;
    private final String _title;
    private final ImageId _imageId;
    private final ImmutableSet<String> _participants;
    private final ImmutableSet<String> _deletedParticipants;
    private final ImmutableSet<String> _userGroups;
    private final DateTime _lastMessageDate;
    private final int _unreadMessagesCount;
    private final DateTime _readDate;
    private final String _teaserMessage;

    @JsonCreator
    public Chat(@JsonProperty(value="id", required=true) String id, @JsonProperty(value="type", required=true) ChatType type, @JsonProperty(value="title", required=true) String title, @JsonProperty(value="imageId") @Nullable ImageId imageId, @JsonProperty(value="participants", required=true) Set<String> participants, @JsonProperty(value="deletedParticipants") @Nullable Set<String> deletedParticipants, @JsonProperty(value="userGroups") @Nullable Set<String> userGroups, @JsonProperty(value="lastMessageDate") @Nullable DateTime lastMessageDate, @JsonProperty(value="unreadMessagesCount") int unreadMessagesCount, @JsonProperty(value="readDate") @Nullable DateTime readDate, @JsonProperty(value="teaserMessage") @Nullable String teaserMessage) {
        this._id = id;
        this._type = type;
        this._title = title;
        this._imageId = imageId;
        this._participants = ImmutableSet.copyOf(participants);
        this._deletedParticipants = deletedParticipants != null ? ImmutableSet.copyOf(deletedParticipants) : ImmutableSet.of();
        this._userGroups = userGroups != null ? ImmutableSet.copyOf(userGroups) : ImmutableSet.of();
        this._lastMessageDate = Dates.orEpoch(lastMessageDate);
        this._unreadMessagesCount = unreadMessagesCount;
        this._readDate = readDate;
        this._teaserMessage = teaserMessage;
    }

    @Nonnull
    public static Chat oneOnOne(String id, String title, ImageId imageId, Set<String> participants, @Nullable Set<String> deletedParticipants, @Nullable DateTime lastMessageDate, int unreadMessagesCount, @Nullable DateTime readDate, @Nullable String teaserMessage) {
        return new Chat(id, ChatType.ONE_ON_ONE, title, imageId, participants, deletedParticipants, null, lastMessageDate, unreadMessagesCount, readDate, teaserMessage);
    }

    @Nonnull
    public static Chat multiUser(String id, String title, Set<String> participants, Set<String> deletedParticipants, @Nullable Set<String> userGroups, @Nullable DateTime lastMessageDate, int unreadMessagesCount, @Nullable DateTime readDate, @Nullable String teaserMessage) {
        return new Chat(id, ChatType.MULTI_USER_CHAT, title, null, participants, deletedParticipants, userGroups, lastMessageDate, unreadMessagesCount, readDate, teaserMessage);
    }

    @Nonnull
    public String getId() {
        return this._id;
    }

    @Nonnull
    public ChatType getType() {
        return this._type;
    }

    @Nonnull
    public String getTitle() {
        return this._title;
    }

    @CheckForNull
    public ImageId getImageId() {
        return this._imageId;
    }

    @Nonnull
    public ImmutableSet<String> getParticipants() {
        return this._participants;
    }

    @Nonnull
    public ImmutableSet<String> getDeletedParticipants() {
        return this._deletedParticipants;
    }

    @Nonnull
    public ImmutableSet<String> getUserGroups() {
        return this._userGroups;
    }

    @Nonnull
    public DateTime getLastMessageDate() {
        return this._lastMessageDate;
    }

    public int getUnreadMessagesCount() {
        return this._unreadMessagesCount;
    }

    @CheckForNull
    public DateTime getReadDate() {
        return this._readDate;
    }

    @CheckForNull
    public String getTeaserMessage() {
        return this._teaserMessage;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("type", (Object)this._type).add("title", (Object)this._title).add("imageId", (Object)this._imageId).add("participants", this._participants).add("deletedParticipants", this._deletedParticipants).add("userGroups", this._userGroups).add("lastMessageDate", (Object)this._lastMessageDate).add("unreadMessagesCount", this._unreadMessagesCount).add("readDate", (Object)this._readDate).add("teaserMessage", (Object)this._teaserMessage).toString();
    }
}

