/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.chat.api.model.exception.InvalidChangeTokenException;
import de.justsoftware.chat.api.util.Strings;
import de.justsoftware.onx.container.shared.model.TenantId;
import java.util.Arrays;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class ChangeToken {
    public static final int VERSION = 4;
    private static final String GROUP_VERSION = "version";
    private static final String GROUP_TIMESTAMP = "timestamp";
    private static final String GROUP_CLIENT_VERSION = "clientVersion";
    private static final String GROUP_TENANT_ID = "tenantId";
    private static final String UUID_PATTERN = "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";
    private static final Pattern PATTERN = Pattern.compile("^(?<version>\\d+):(?<timestamp>\\d+):(?<clientVersion>\\d+):(?<tenantId>[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12})$");
    private final int _version;
    private final DateTime _timestamp;
    private final long _clientVersion;
    private final TenantId _tenantId;

    public ChangeToken(DateTime timestamp, long clientVersion, TenantId tenantId) {
        this(4, timestamp, clientVersion, tenantId);
    }

    private ChangeToken(int version, DateTime timestamp, long clientVersion, TenantId tenantId) {
        this._version = version;
        this._timestamp = timestamp;
        this._clientVersion = clientVersion;
        this._tenantId = tenantId;
    }

    public int getVersion() {
        return this._version;
    }

    @Nonnull
    public DateTime getTimestamp() {
        return this._timestamp;
    }

    public long getClientVersion() {
        return this._clientVersion;
    }

    @Nonnull
    public TenantId getTenantId() {
        return this._tenantId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(GROUP_VERSION, this._version).add(GROUP_TIMESTAMP, (Object)this._timestamp).add(GROUP_CLIENT_VERSION, this._clientVersion).add(GROUP_TENANT_ID, (Object)this._tenantId).toString();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ChangeToken && Arrays.equals(this.getHashObjects(), ((ChangeToken)obj).getHashObjects());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getHashObjects());
    }

    @Nonnull
    private Object[] getHashObjects() {
        return new Object[]{this._version, this._timestamp, this._clientVersion, this._tenantId};
    }

    @Nonnull
    public String encode() {
        return Strings.encodeBase64(String.format("%d:%d:%d:%s", this._version, this._timestamp.getMillis(), this._clientVersion, this._tenantId.getId()));
    }

    @Nonnull
    public static ChangeToken decode(String encoded) {
        try {
            Matcher matcher = PATTERN.matcher(Strings.decodeBase64(encoded));
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Unable to parse change token: " + encoded);
            }
            int version = ChangeToken.parseInt(matcher, GROUP_VERSION);
            DateTime timestamp = ChangeToken.parseDateTime(matcher, GROUP_TIMESTAMP);
            long clientVersion = ChangeToken.parseLong(matcher, GROUP_CLIENT_VERSION);
            UUID tenantUUID = ChangeToken.parseUUID(matcher, GROUP_TENANT_ID);
            return new ChangeToken(version, timestamp, clientVersion, new TenantId(tenantUUID));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidChangeTokenException(e);
        }
    }

    private static int parseInt(Matcher matcher, String groupName) {
        return Integer.parseInt(matcher.group(groupName));
    }

    private static long parseLong(Matcher matcher, String groupName) {
        return Long.parseLong(matcher.group(groupName));
    }

    @Nonnull
    private static DateTime parseDateTime(Matcher matcher, String groupName) {
        long parsed = ChangeToken.parseLong(matcher, groupName);
        return new DateTime(parsed);
    }

    @Nonnull
    private static UUID parseUUID(Matcher matcher, String groupName) {
        String uuidString = matcher.group(groupName);
        return UUID.fromString(uuidString);
    }

    @CheckForNull
    public static DateTime timestamp(@Nullable ChangeToken token) {
        return token != null ? token.getTimestamp() : null;
    }
}

