/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.api.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import de.justsoftware.chat.api.model.ChangeOperation;
import de.justsoftware.chat.api.model.ChangeType;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE)
public interface Change {
    @Nonnull
    @JsonProperty(value="operation")
    public ChangeOperation getOperation();

    @Nonnull
    @JsonProperty(value="type")
    public ChangeType getType();

    @Nonnull
    public DateTime getTimestamp();

    @ParametersAreNonnullByDefault
    public static abstract class Delete
    implements Change {
        private final String _id;
        private final DateTime _timestamp;

        protected Delete(String id, DateTime timestamp) {
            this._id = id;
            this._timestamp = timestamp;
        }

        @Override
        @Nonnull
        public ChangeOperation getOperation() {
            return ChangeOperation.DELETE;
        }

        @JsonProperty(value="id")
        @Nonnull
        public String getId() {
            return this._id;
        }

        @Override
        @Nonnull
        public DateTime getTimestamp() {
            return this._timestamp;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("operation", (Object)this.getOperation()).add("type", (Object)this.getType()).add("timestamp", (Object)this._timestamp).add("id", (Object)this._id).toString();
        }
    }

    public static abstract class Update<T>
    implements Change {
        @Override
        @Nonnull
        public ChangeOperation getOperation() {
            return ChangeOperation.UPDATE;
        }

        @JsonProperty(value="item")
        @Nonnull
        public abstract T getItem();

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("operation", (Object)this.getOperation()).add("type", (Object)this.getType()).add("timestamp", (Object)this.getTimestamp()).add("item", this.getItem()).toString();
        }
    }
}

